"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initialUserPrivilegesState = exports.UserPrivilegesProvider = exports.UserPrivilegesContext = void 0;
var _react = _interopRequireWildcard(require("react"));
var _constants = require("../../../../common/constants");
var _use_fetch_list_privileges = require("../../../detections/components/user_privileges/use_fetch_list_privileges");
var _use_fetch_detection_engine_privileges = require("../../../detections/components/user_privileges/use_fetch_detection_engine_privileges");
var _endpoint = require("./endpoint");
var _timeline_capabilities = require("../../utils/timeline_capabilities");
var _notes_capabilities = require("../../utils/notes_capabilities");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/user_privileges/user_privileges_context.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const initialUserPrivilegesState = () => ({
  listPrivileges: {
    loading: false,
    error: undefined,
    result: undefined
  },
  detectionEnginePrivileges: {
    loading: false,
    error: undefined,
    result: undefined
  },
  endpointPrivileges: (0, _endpoint.getEndpointPrivilegesInitialState)(),
  kibanaSecuritySolutionsPrivileges: {
    crud: false,
    read: false
  },
  timelinePrivileges: {
    crud: false,
    read: false
  },
  notesPrivileges: {
    crud: false,
    read: false
  }
});
exports.initialUserPrivilegesState = initialUserPrivilegesState;
const UserPrivilegesContext = exports.UserPrivilegesContext = /*#__PURE__*/(0, _react.createContext)(initialUserPrivilegesState());
const UserPrivilegesProvider = ({
  kibanaCapabilities,
  children
}) => {
  const crud = kibanaCapabilities[_constants.SECURITY_FEATURE_ID].crud === true;
  const read = kibanaCapabilities[_constants.SECURITY_FEATURE_ID].show === true;
  const listPrivileges = (0, _use_fetch_list_privileges.useFetchListPrivileges)(read);
  const detectionEnginePrivileges = (0, _use_fetch_detection_engine_privileges.useFetchDetectionEnginePrivileges)(read);
  const endpointPrivileges = (0, _endpoint.useEndpointPrivileges)();
  const kibanaSecuritySolutionsPrivileges = (0, _react.useMemo)(() => ({
    crud,
    read
  }), [crud, read]);
  const timelinePrivileges = (0, _react.useMemo)(() => (0, _timeline_capabilities.extractTimelineCapabilities)(kibanaCapabilities), [kibanaCapabilities]);
  const notesPrivileges = (0, _react.useMemo)(() => (0, _notes_capabilities.extractNotesCapabilities)(kibanaCapabilities), [kibanaCapabilities]);
  const contextValue = (0, _react.useMemo)(() => ({
    listPrivileges,
    detectionEnginePrivileges,
    endpointPrivileges,
    kibanaSecuritySolutionsPrivileges,
    timelinePrivileges,
    notesPrivileges
  }), [listPrivileges, detectionEnginePrivileges, endpointPrivileges, kibanaSecuritySolutionsPrivileges, timelinePrivileges, notesPrivileges]);
  return /*#__PURE__*/_react.default.createElement(UserPrivilegesContext.Provider, {
    value: contextValue,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 93,
      columnNumber: 5
    }
  }, children);
};
exports.UserPrivilegesProvider = UserPrivilegesProvider;