"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThreatMatchComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _styledComponents = _interopRequireDefault(require("styled-components"));
var _list_item = require("./list_item");
var _and_or_badge = require("../and_or_badge");
var _logic_buttons = require("./logic_buttons");
var _helpers = require("./helpers");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/threat_match/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MyInvisibleAndBadge = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  visibility: hidden;
`;
const MyAndBadge = (0, _styledComponents.default)(_and_or_badge.AndOrBadge)`
  & > .euiFlexItem {
    margin: 0;
  }
`;
const MyButtonsContainer = (0, _styledComponents.default)(_eui.EuiFlexItem)`
  margin: 16px 0;
`;
const ThreatMatchComponent = ({
  mappingEntries,
  indexPatterns,
  threatIndexPatterns,
  'id-aria': idAria,
  'data-test-subj': dataTestSubj,
  onMappingEntriesChange
}) => {
  const handleEntryItemChange = (0, _react.useCallback)((item, index) => {
    const updatedEntries = mappingEntries.slice();
    updatedEntries.splice(index, 1, item);
    onMappingEntriesChange(updatedEntries);
  }, [mappingEntries, onMappingEntriesChange]);
  const handleDeleteEntryItem = (0, _react.useCallback)((item, index) => {
    if (item.entries.length === 0) {
      const updatedEntries = mappingEntries.slice();
      updatedEntries.splice(index, 1);
      onMappingEntriesChange(updatedEntries);
    } else {
      handleEntryItemChange(item, index);
    }
  }, [mappingEntries, onMappingEntriesChange, handleEntryItemChange]);
  const handleOrClick = (0, _react.useCallback)(() => {
    // There is a case where there are numerous list items, all with
    // empty `entries` array.

    onMappingEntriesChange([...mappingEntries, (0, _helpers.createOrNewEntryItem)()]);
  }, [mappingEntries, onMappingEntriesChange]);
  const handleAndClick = (0, _react.useCallback)(() => {
    const lastEntry = mappingEntries.at(-1);
    if (!lastEntry) {
      onMappingEntriesChange([(0, _helpers.createOrNewEntryItem)()]);
      return;
    }
    const {
      entries: innerEntries
    } = lastEntry;
    const updatedEntry = {
      ...lastEntry,
      entries: [...innerEntries, (0, _helpers.createAndNewEntryItem)()]
    };
    onMappingEntriesChange([...mappingEntries.slice(0, -1), updatedEntry]);
  }, [mappingEntries, onMappingEntriesChange]);
  const andLogicIncluded = (0, _react.useMemo)(() => mappingEntries.some(({
    entries
  }) => entries.length > 1), [mappingEntries]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    direction: "column",
    "id-aria": idAria,
    "data-test-subj": dataTestSubj,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 5
    }
  }, mappingEntries.map((entryListItem, index) => {
    var _id;
    const key = (_id = entryListItem.id) !== null && _id !== void 0 ? _id : `${index}`;
    return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: 1,
      key: key,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      direction: "column",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 13
      }
    }, index !== 0 && (andLogicIncluded ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 113,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "none",
      direction: "row",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 21
      }
    }, /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
      includeAntennas: true,
      type: "and",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 25
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 118,
        columnNumber: 23
      }
    }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
      type: "or",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 119,
        columnNumber: 25
      }
    })))) : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(MyAndBadge, {
      type: "or",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 21
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 128,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_list_item.ListItemComponent, {
      key: key,
      listItem: entryListItem,
      indexPattern: indexPatterns,
      threatIndexPatterns: threatIndexPatterns,
      listItemIndex: index,
      andLogicIncluded: andLogicIncluded,
      isOnlyItem: mappingEntries.length === 1,
      onDeleteEntryItem: handleDeleteEntryItem,
      onChangeEntryItem: handleEntryItemChange,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 17
      }
    }))));
  }), /*#__PURE__*/_react.default.createElement(MyButtonsContainer, {
    "data-test-subj": "andOrOperatorButtons",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 9
    }
  }, andLogicIncluded && /*#__PURE__*/_react.default.createElement(MyInvisibleAndBadge, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 149,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_and_or_badge.AndOrBadge, {
    includeAntennas: true,
    type: "and",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 15
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 1,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 153,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_logic_buttons.LogicButtons, {
    isOrDisabled: false,
    isAndDisabled: false,
    onOrClicked: handleOrClick,
    onAndClicked: handleAndClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 154,
      columnNumber: 13
    }
  })))));
};
exports.ThreatMatchComponent = ThreatMatchComponent;
ThreatMatchComponent.displayName = 'ThreatMatch';