"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ResponseActionsResults = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _endpoint_action_results = require("./endpoint_action_results");
var _kibana = require("../../lib/kibana");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/response_actions/response_actions_results.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ResponseActionsResults = exports.ResponseActionsResults = /*#__PURE__*/_react.default.memo(({
  actions,
  ruleName,
  ecsData
}) => {
  const {
    services: {
      osquery
    }
  } = (0, _kibana.useKibana)();
  const {
    OsqueryResult
  } = osquery;
  const getAction = (0, _react.useCallback)(action => {
    if (isOsquery(action)) {
      const actionId = action.action_id;
      const startDate = action['@timestamp'];
      return /*#__PURE__*/_react.default.createElement(OsqueryResult, {
        key: actionId,
        actionId: actionId,
        startDate: startDate,
        ruleName: ruleName,
        ecsData: ecsData,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 39,
          columnNumber: 13
        }
      });
    }
    if (isEndpoint(action)) {
      return /*#__PURE__*/_react.default.createElement(_endpoint_action_results.EndpointResponseActionResults, {
        action: action,
        ruleName: ruleName,
        key: action.EndpointActions.action_id,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 50,
          columnNumber: 13
        }
      });
    }
    return null;
  }, [OsqueryResult, ecsData, ruleName]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, actions.map(action => {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 67,
        columnNumber: 15
      }
    }), getAction(action), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 15
      }
    }));
  }));
});
ResponseActionsResults.displayName = 'ResponseActionsResults';
const isOsquery = item => {
  return !!(item && 'input_type' in item && (item === null || item === void 0 ? void 0 : item.input_type) === 'osquery');
};
const isEndpoint = item => {
  var _item$EndpointActions;
  return !!(item && 'EndpointActions' in item && (item === null || item === void 0 ? void 0 : (_item$EndpointActions = item.EndpointActions) === null || _item$EndpointActions === void 0 ? void 0 : _item$EndpointActions.input_type) === 'endpoint');
};