"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OsqueryRenderer = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _use_upselling = require("../../../../hooks/use_upselling");
var _investigation_guide_view = require("../../../../../flyout/document_details/left/components/investigation_guide_view");
var _expand_dotted = require("../../../../../../common/utils/expand_dotted");
var _osquery = _interopRequireDefault(require("./osquery_icon/osquery.svg"));
var _osquery_flyout = require("../../../../../detections/components/osquery/osquery_flyout");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/markdown_editor/plugins/osquery/renderer.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// receives the configuration from the parser and renders
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const OsqueryRenderer = ({
  configuration
}) => {
  var _configuration$label;
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const {
    agentId,
    alertId,
    data
  } = (0, _react.useContext)(_investigation_guide_view.BasicAlertDataContext);
  const handleOpen = (0, _react.useCallback)(() => setShowFlyout(true), [setShowFlyout]);
  const handleClose = (0, _react.useCallback)(() => setShowFlyout(false), [setShowFlyout]);
  const interactionsUpsellingMessage = (0, _use_upselling.useUpsellingMessage)('investigation_guide_interactions');
  const ecsData = (0, _react.useMemo)(() => {
    const fieldsMap = (0, _lodash.reduce)(data, (acc, eventDetailItem) => {
      var _eventDetailItem$valu;
      return {
        ...acc,
        [eventDetailItem.field]: eventDetailItem === null || eventDetailItem === void 0 ? void 0 : (_eventDetailItem$valu = eventDetailItem.values) === null || _eventDetailItem$valu === void 0 ? void 0 : _eventDetailItem$valu[0]
      };
    }, {});
    return (0, _expand_dotted.expandDottedObject)(fieldsMap);
  }, [data]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
    content: interactionsUpsellingMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 54,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: _osquery.default,
    onClick: handleOpen,
    disabled: !!interactionsUpsellingMessage,
    css: (0, _react2.css)`
            > span > img {
              margin-block-end: 0;
            }
          `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 9
    }
  }, (_configuration$label = configuration.label) !== null && _configuration$label !== void 0 ? _configuration$label : _i18n.i18n.translate('xpack.securitySolution.markdown.osquery.runOsqueryButtonLabel', {
    defaultMessage: 'Run Osquery'
  }))), showFlyout && /*#__PURE__*/_react.default.createElement(_osquery_flyout.OsqueryFlyout, {
    defaultValues: {
      ...(alertId ? {
        alertIds: [alertId]
      } : {}),
      query: configuration.query,
      ecs_mapping: configuration.ecs_mapping,
      queryField: false
    },
    agentId: agentId,
    onClose: handleClose,
    ecsData: ecsData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 9
    }
  }));
};
exports.OsqueryRenderer = OsqueryRenderer;