"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Title = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _styled = _interopRequireDefault(require("@emotion/styled"));
var _truncatable_text = require("../truncatable_text");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/header_page/title.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const Header = _styled.default.h1`
  display: grid;
  grid-gap: 12px;
  grid-template-columns: auto auto;
  align-items: center;
  justify-items: start;
  justify-content: start;
`;
Header.displayName = 'Header';
const TitleWrapper = _styled.default.span`
  // Without  min-width: 0, as a flex child, it wouldn't shrink properly
  // and could overflow its parent.
  min-width: 0;
  max-width: 100%;
`;
TitleWrapper.displayName = 'TitleWrapper';
const TitleComponent = ({
  title,
  badgeOptions
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
  size: "l",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 39,
    columnNumber: 3
  }
}, /*#__PURE__*/_react.default.createElement(Header, {
  "data-test-subj": "header-page-title",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 40,
    columnNumber: 5
  }
}, /*#__PURE__*/_react.default.createElement(TitleWrapper, {
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 41,
    columnNumber: 7
  }
}, /*#__PURE__*/_react.default.createElement(_truncatable_text.TruncatableText, {
  tooltipContent: typeof title === 'string' ? title : null,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 42,
    columnNumber: 9
  }
}, title)), badgeOptions && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, badgeOptions.beta ? /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
  "data-test-subj": "header-page-title-beta-badge",
  label: badgeOptions.text,
  tooltipContent: badgeOptions.tooltip,
  tooltipPosition: "bottom",
  size: badgeOptions.size,
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 49,
    columnNumber: 13
  }
}) : /*#__PURE__*/_react.default.createElement(_eui.EuiBadge, {
  "data-test-subj": "header-page-title-badge",
  color: badgeOptions.color || 'hollow',
  title: "",
  __self: void 0,
  __source: {
    fileName: _jsxFileName,
    lineNumber: 57,
    columnNumber: 13
  }
}, badgeOptions.text))));
const Title = exports.Title = /*#__PURE__*/_react.default.memo(TitleComponent);