"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformControlColumns = void 0;
var _react = _interopRequireDefault(require("react"));
var _securitysolutionDataTable = require("@kbn/securitysolution-data-table");
var _row_action = require("./row_action");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/control_columns/transform_control_columns.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const EmptyHeaderCellRender = () => null;
const transformControlColumns = ({
  columnHeaders,
  controlColumns,
  data,
  fieldBrowserOptions,
  loadingEventIds,
  onRowSelected,
  onRuleChange,
  selectedEventIds,
  showCheckboxes,
  tabType,
  timelineId,
  isSelectAllChecked,
  onSelectPage,
  browserFields,
  pageSize,
  sort,
  theme,
  setEventsLoading,
  setEventsDeleted
}) => {
  return controlColumns.map(({
    id: columnId,
    headerCellRender = EmptyHeaderCellRender,
    rowCellRender,
    width
  }, i) => ({
    id: `${columnId}`,
    headerCellRender: () => {
      const HeaderActions = headerCellRender;
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, HeaderActions && /*#__PURE__*/_react.default.createElement(HeaderActions, {
        width: width,
        browserFields: browserFields,
        fieldBrowserOptions: fieldBrowserOptions,
        columnHeaders: columnHeaders,
        isEventViewer: false,
        isSelectAllChecked: isSelectAllChecked,
        onSelectAll: onSelectPage,
        showEventsSelect: false,
        showSelectAllCheckbox: showCheckboxes,
        sort: sort,
        tabType: tabType,
        timelineId: timelineId,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 15
        }
      }));
    },
    rowCellRender: ({
      isDetails,
      isExpandable,
      isExpanded,
      rowIndex,
      colIndex,
      setCellProps
    }) => {
      const pageRowIndex = (0, _securitysolutionDataTable.getPageRowIndex)(rowIndex, pageSize);
      const rowData = data[pageRowIndex];
      if (rowData) {
        (0, _securitysolutionDataTable.addBuildingBlockStyle)(rowData.ecs, theme, setCellProps);
      } else {
        // disable the cell when it has no data
        setCellProps({
          style: {
            display: 'none'
          }
        });
      }
      return /*#__PURE__*/_react.default.createElement(_row_action.RowAction, {
        columnId: columnId !== null && columnId !== void 0 ? columnId : '',
        columnHeaders: columnHeaders,
        controlColumn: controlColumns[i],
        data: data[pageRowIndex],
        disabled: false,
        index: i,
        isDetails: isDetails,
        isExpanded: isExpanded,
        isEventViewer: false,
        isExpandable: isExpandable,
        loadingEventIds: loadingEventIds,
        onRowSelected: onRowSelected,
        onRuleChange: onRuleChange,
        rowIndex: rowIndex,
        colIndex: colIndex,
        pageRowIndex: pageRowIndex,
        selectedEventIds: selectedEventIds,
        setCellProps: setCellProps,
        showCheckboxes: showCheckboxes,
        tabType: tabType,
        tableId: timelineId,
        width: width,
        setEventsLoading: setEventsLoading,
        setEventsDeleted: setEventsDeleted,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 120,
          columnNumber: 11
        }
      });
    },
    width
  }));
};
exports.transformControlColumns = transformControlColumns;