"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGetFindingsStats = exports.MisconfigurationsPreview = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _securitySolutionDistributionBar = require("@kbn/security-solution-distribution-bar");
var _use_has_misconfigurations = require("@kbn/cloud-security-posture/src/hooks/use_has_misconfigurations");
var _i18n = require("@kbn/i18n");
var _cloudSecurityPosture = require("@kbn/cloud-security-posture");
var _cloudSecurityPostureCommon = require("@kbn/cloud-security-posture-common");
var _analytics = require("@kbn/analytics");
var _ui_metrics = require("@kbn/cloud-security-posture-common/utils/ui_metrics");
var _expandable_panel = require("../../../flyout/shared/components/expandable_panel");
var _left_panel_header = require("../../../flyout/entity_details/shared/components/left_panel/left_panel_header");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/cloud_security_posture/components/misconfiguration/misconfiguration_preview.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const useGetFindingsStats = (passedFindingsStats, failedFindingsStats) => {
  const {
    getMisconfigurationStatusColor
  } = (0, _cloudSecurityPosture.useGetMisconfigurationStatusColor)();
  return (0, _react.useMemo)(() => {
    const misconfigurationStats = [];
    if (passedFindingsStats === 0 && failedFindingsStats === 0) return [];
    if (passedFindingsStats > 0) {
      misconfigurationStats.push({
        key: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.misconfigurations.passedFindingsText', {
          defaultMessage: '{count, plural, one {Passed finding} other {Passed findings}}',
          values: {
            count: passedFindingsStats
          }
        }),
        count: passedFindingsStats,
        color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.PASSED)
      });
    }
    if (failedFindingsStats > 0) {
      misconfigurationStats.push({
        key: _i18n.i18n.translate('xpack.securitySolution.flyout.right.insights.misconfigurations.failedFindingsText', {
          defaultMessage: '{count, plural, one {Failed finding} other {Failed findings}}',
          values: {
            count: failedFindingsStats
          }
        }),
        count: failedFindingsStats,
        color: getMisconfigurationStatusColor(_cloudSecurityPostureCommon.MISCONFIGURATION_STATUS.FAILED)
      });
    }
    return misconfigurationStats;
  }, [passedFindingsStats, failedFindingsStats, getMisconfigurationStatusColor]);
};
exports.useGetFindingsStats = useGetFindingsStats;
const MisconfigurationPreviewScore = ({
  passedFindings,
  failedFindings
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 85,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("h3", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, `${Math.round(passedFindings / (passedFindings + failedFindings) * 100)}%`))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 89,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "xs",
    css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.securitySolution.flyout.right.insights.misconfigurations.postureScoreDescription",
    defaultMessage: "Posture score",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 13
    }
  })))));
};
const MisconfigurationsPreview = ({
  value,
  field,
  isPreviewMode,
  openDetailsPanel
}) => {
  const {
    hasMisconfigurationFindings,
    passedFindings,
    failedFindings
  } = (0, _use_has_misconfigurations.useHasMisconfigurations)(field, value);
  const findingsStats = useGetFindingsStats(passedFindings, failedFindings);
  (0, _react.useEffect)(() => {
    _ui_metrics.uiMetricService.trackUiMetric(_analytics.METRIC_TYPE.CLICK, _ui_metrics.ENTITY_FLYOUT_WITH_MISCONFIGURATION_VISIT);
  }, []);
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const goToEntityInsightTab = (0, _react.useCallback)(() => openDetailsPanel({
    tab: _left_panel_header.EntityDetailsLeftPanelTab.CSP_INSIGHTS,
    subTab: _left_panel_header.CspInsightLeftPanelSubTab.MISCONFIGURATIONS
  }), [openDetailsPanel]);
  const link = (0, _react.useMemo)(() => ({
    callback: goToEntityInsightTab,
    tooltip: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.securitySolution.flyout.right.insights.misconfiguration.misconfigurationTooltip",
      defaultMessage: "Show all misconfiguration findings",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 9
      }
    })
  }), [goToEntityInsightTab]);
  return /*#__PURE__*/_react.default.createElement(_expandable_panel.ExpandablePanel, {
    header: {
      iconType: !isPreviewMode && hasMisconfigurationFindings ? 'arrowStart' : '',
      title: /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
        css: (0, _react2.css)`
              font-weight: ${euiTheme.font.weight.semiBold};
            `,
        "data-test-subj": 'securitySolutionFlyoutInsightsMisconfigurationsTitleText',
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 155,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.securitySolution.flyout.right.insights.misconfigurations.misconfigurationsTitle",
        defaultMessage: "Misconfigurations",
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 161,
          columnNumber: 13
        }
      })),
      link: hasMisconfigurationFindings ? link : undefined
    },
    "data-test-subj": 'securitySolutionFlyoutInsightsMisconfigurations',
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 151,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 171,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(MisconfigurationPreviewScore, {
    passedFindings: passedFindings,
    failedFindings: failedFindings,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 172,
      columnNumber: 9
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 2,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 177,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 178,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 179,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 180,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 181,
      columnNumber: 15
    }
  }), /*#__PURE__*/_react.default.createElement(_securitySolutionDistributionBar.DistributionBar, {
    stats: findingsStats,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 182,
      columnNumber: 15
    }
  }))))));
};
exports.MisconfigurationsPreview = MisconfigurationsPreview;