"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccordionButton = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _aiAssistantIcon = require("@kbn/ai-assistant-icon");
var _react2 = _interopRequireDefault(require("react"));
var _accordion_title = require("./accordion_title");
var i18n = _interopRequireWildcard(require("./translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/results/attack_discovery_panel/panel_header/primary_interactions/accordion_button/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const AVATAR_SIZE = 24; // px

const AccordionButtonComponent = ({
  connectorName,
  isLoading,
  replacements,
  showAnonymized = false,
  title
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    css: (0, _react.css)`
        gap: ${euiTheme.size.xs};
      `,
    "data-test-subj": "nonWrapping",
    gutterSize: "none",
    responsive: false,
    wrap: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    "data-test-subj": "assistantAvatar",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
            background-color: ${euiTheme.colors.lightestShade};
            border-radius: 50%;
            display: inline;
            height: ${AVATAR_SIZE}px;
            width: ${AVATAR_SIZE}px;
            overflow: hidden;
          `,
    "data-test-subj": "assistantAvatarContainer",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiToolTip, {
    content: connectorName != null ? connectorName : undefined,
    "data-test-subj": "connectorTooltip",
    position: "right",
    title: connectorName != null ? i18n.AI_CONNECTOR : undefined,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_aiAssistantIcon.AssistantIcon, {
    css: (0, _react.css)`
                transform: translate(5px, -1px);
                overflow: hidden;
              `,
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 76,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_accordion_title.AccordionTitle, {
    isLoading: isLoading,
    replacements: replacements,
    showAnonymized: showAnonymized,
    title: title,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 77,
      columnNumber: 9
    }
  })));
};
AccordionButtonComponent.displayName = 'AccordionButton';
const AccordionButton = exports.AccordionButton = /*#__PURE__*/_react2.default.memo(AccordionButtonComponent);