"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Countdown = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _info_popover_body = require("../info_popover_body");
var _helpers = require("./last_times_popover/helpers");
var i18n = _interopRequireWildcard(require("../translations"));
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/attack_discovery/pages/loading_callout/countdown/index.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const TEXT_COLOR = '#343741';
const CountdownComponent = ({
  approximateFutureTime,
  averageSuccessfulDurationNanoseconds,
  successfulGenerations
}) => {
  // theming:
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const isDarkMode = (0, _reactKibanaContextTheme.useKibanaIsDarkMode)();

  // popover state:
  const [isPopoverOpen, setIsPopoverOpen] = (0, _react2.useState)(false);
  const closePopover = (0, _react2.useCallback)(() => setIsPopoverOpen(false), []);
  const onClick = (0, _react2.useCallback)(() => setIsPopoverOpen(true), []);

  // state for the timer prefix, and timer text:
  const [prefix, setPrefix] = (0, _react2.useState)((0, _helpers.getTimerPrefix)(approximateFutureTime));
  const [timerText, setTimerText] = (0, _react2.useState)('');
  (0, _react2.useEffect)(() => {
    // periodically update the formatted date as time passes:
    if (approximateFutureTime === null) {
      return;
    }
    const intervalId = setInterval(() => {
      setPrefix((0, _helpers.getTimerPrefix)(approximateFutureTime));
      if (approximateFutureTime !== null) {
        const now = (0, _moment.default)();
        const duration = (0, _moment.default)(approximateFutureTime).isSameOrAfter(now) ? _moment.default.duration((0, _moment.default)(approximateFutureTime).diff(now)) : _moment.default.duration(now.diff(approximateFutureTime));
        const text = _moment.default.utc(duration.asMilliseconds()).format('mm:ss');
        setTimerText(text);
      }
    }, 1000);
    return () => clearInterval(intervalId);
  }, [approximateFutureTime]);
  const iconInQuestionButton = (0, _react2.useMemo)(() => /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": i18n.INFORMATION,
    iconType: "question",
    onClick: onClick,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 75,
      columnNumber: 11
    }
  }), [onClick]);
  if (approximateFutureTime == null) {
    return null; // don't render anything if there's no data
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    "data-test-subj": "countdown",
    gutterSize: "none",
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiOutsideClickDetector, {
    isDisabled: !isPopoverOpen,
    onOutsideClick: () => closePopover(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 91,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    anchorPosition: "upCenter",
    button: iconInQuestionButton,
    closePopover: closePopover,
    "data-test-subj": "infoPopover",
    isOpen: isPopoverOpen,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 92,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement(_info_popover_body.InfoPopoverBody, {
    averageSuccessfulDurationNanoseconds: averageSuccessfulDurationNanoseconds,
    successfulGenerations: successfulGenerations,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    color: isDarkMode ? 'subdued' : TEXT_COLOR,
    css: (0, _react.css)`
            font-weight: 400;
            margin-left: ${euiTheme.size.xs};
          `,
    "data-test-subj": "prefix",
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 9
    }
  }, prefix)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
          margin-left: ${euiTheme.size.s};
        `,
    "data-test-subj": "timerText",
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 7
    }
  }, timerText));
};
CountdownComponent.displayName = 'Countdown';
const Countdown = exports.Countdown = /*#__PURE__*/_react2.default.memo(CountdownComponent);