"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.QradarRulesXmlParser = void 0;
var _xml2js = _interopRequireDefault(require("xml2js"));
var _xml = require("../xml/xml");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class QradarRulesXmlParser extends _xml.XmlParser {
  async processRuleXml(qradarRule) {
    var _this$findDeepValue;
    const ruleData = this.getStrValue(this.findDeep(qradarRule, 'rule_data'));
    let decodedRuleData;
    try {
      decodedRuleData = Buffer.from(ruleData, 'base64').toString('utf-8');
    } catch (error) {
      throw new Error(`Failed to decode rule_data from base64: ${error.message}`);
    }
    const parsedRuleData = await this.parseRuleData(decodedRuleData);
    const id = this.findDeepValue(parsedRuleData, 'rule', 'id');
    const name = this.findDeep(parsedRuleData, 'name');
    const notes = this.findDeep(parsedRuleData, 'notes');
    const isBuildingBlockVal = (_this$findDeepValue = this.findDeepValue(parsedRuleData, 'rule', 'buildingBlock')) !== null && _this$findDeepValue !== void 0 ? _this$findDeepValue : 'false';
    if (name && notes && isBuildingBlockVal) {
      const title = this.getStrValue(name);
      const description = this.getStrValue(notes);
      const isBuildingBlock = isBuildingBlockVal === 'true';
      return {
        id: id,
        title,
        description,
        rule_type: isBuildingBlock ? 'building_block' : 'default',
        rule_data: decodedRuleData
      };
    }
  }
  async getRules() {
    const parsedXml = await this.parse();
    const rules = this.findDeep(parsedXml, 'custom_rule');
    const qradarRules = Array.isArray(rules) ? rules : [];
    const processQradarRulePromises = qradarRules.map(this.processRuleXml.bind(this));
    const parsedRules = await Promise.all(processQradarRulePromises);
    return parsedRules.filter(Boolean);
  }
  async parseRuleData(ruleData) {
    return _xml2js.default.parseStringPromise(ruleData, {
      explicitArray: true
    });
  }
  async parseSeverityFromRuleData(ruleData) {
    const parsedRuleData = await this.parseRuleData(ruleData);
    return this.findDeepValue(parsedRuleData, 'newevent', 'severity');
  }
  async getResources() {
    const parsedXml = await this.parse();
    const [sensordevicetypes] = await Promise.all([this.getSensortDeviceType(parsedXml)]);
    return {
      qidmap: undefined,
      reference_data_rules: undefined,
      sensordevicetype: sensordevicetypes,
      sensordeviceprotocols: undefined,
      sensordevicecategory: undefined,
      ariel_property_expression: undefined,
      ariel_regex_property: undefined,
      reference_data: undefined,
      offense_type: undefined
    };
  }
  async getSensortDeviceType(parsedXml) {
    var _ref;
    const sensordevicetypes = this.findDeep(parsedXml, 'sensordevicetype');
    return ((_ref = Array.isArray(sensordevicetypes) ? sensordevicetypes : []) === null || _ref === void 0 ? void 0 : _ref.map(deviceType => ({
      name: this.getStrValue(deviceType.devicetypename),
      description: this.getStrValue(deviceType.devicetypedescription),
      content: JSON.stringify(deviceType)
    }))) || [];
  }
  getStrValue(val) {
    if (Array.isArray(val)) {
      return val[0].trim();
    }
    return val.trim();
  }
}
exports.QradarRulesXmlParser = QradarRulesXmlParser;