"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MemoryDumpActionRequestSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _ = require("../../..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const MemoryDumpActionRequestSchema = exports.MemoryDumpActionRequestSchema = {
  body: _configSchema.schema.object({
    ..._.BaseActionRequestSchema,
    parameters: _configSchema.schema.object({
      type: _configSchema.schema.oneOf([_configSchema.schema.literal('process'), _configSchema.schema.literal('kernel')]),
      pid: _configSchema.schema.maybe(_configSchema.schema.number({
        min: 1
      })),
      entity_id: _configSchema.schema.maybe(_configSchema.schema.string({
        minLength: 1,
        validate: value => {
          if (!value.trim().length) {
            return `entity_id cannot be an empty string`;
          }
        }
      }))
    }, {
      validate: parameters => {
        if (parameters.type === 'kernel' && (parameters.pid || parameters.entity_id)) {
          return '"pid" and "entity_id" parameters only supported for type of "process"';
        }
        if (parameters.type === 'process') {
          if (!parameters.pid && !parameters.entity_id) {
            return 'Type of "process" requires either "pid" or "entity_id"';
          }
          if (parameters.pid !== undefined && parameters.entity_id !== undefined) {
            return 'Type of "process" cannot have both "pid" and "entity_id"';
          }
        }
      }
    })
  })
};