"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  defaultNavigationTree: true
};
exports.defaultNavigationTree = void 0;
var _dashboards_navigation_tree = require("./dashboards_navigation_tree");
var _rules_navigation_tree = require("./rules_navigation_tree");
var _cases_navigation_tree = require("./cases_navigation_tree");
var _investigations_navigation_tree = require("./investigations_navigation_tree");
var _explore_navigation_tree = require("./explore_navigation_tree");
var _assets_navigation_tree = require("./assets_navigation_tree");
var _entity_analytics_navigation_tree = require("./entity_analytics_navigation_tree");
var _ml_navigation_tree = require("./ml_navigation_tree");
var _alert_detections_navigation_tree = require("./alert_detections_navigation_tree");
var _custom_icons = require("./custom_icons");
Object.keys(_custom_icons).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _custom_icons[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _custom_icons[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const defaultNavigationTree = exports.defaultNavigationTree = {
  alertDetections: _alert_detections_navigation_tree.createAlertDetectionsNavigationTree,
  dashboards: _dashboards_navigation_tree.createDashboardsNavigationTree,
  rules: _rules_navigation_tree.createRulesNavigationTree,
  cases: _cases_navigation_tree.createCasesNavigationTree,
  investigations: _investigations_navigation_tree.createInvestigationsNavigationTree,
  explore: _explore_navigation_tree.createExploreNavigationTree,
  assets: _assets_navigation_tree.createAssetsNavigationTree,
  entityAnalytics: _entity_analytics_navigation_tree.createEntityAnalyticsNavigationTree,
  ml: _ml_navigation_tree.createMachineLearningNavigationTree
};