"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingLink = exports.LandingColumnLinks = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _links = require("../links");
var _utils = require("./utils");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/packages/navigation/src/landing_links/landing_links.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// Renders a link to either an external URL or an internal Kibana URL
const LandingLink = exports.LandingLink = /*#__PURE__*/_react.default.memo(function LandingLink({
  item,
  urlState,
  onLinkClick,
  children,
  ...rest
}) {
  const linkProps = {
    ...(0, _utils.getKibanaLinkProps)({
      item,
      urlState,
      onLinkClick
    }),
    ...rest
  };
  return /*#__PURE__*/_react.default.createElement(_links.LinkAnchor, (0, _extends2.default)({}, linkProps, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 39,
      columnNumber: 10
    }
  }), children);
});
const useSubLinkStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  return {
    container: (0, _react2.css)`
      margin-top: ${euiTheme.size.base};
    `
  };
};

// Renders a list of links in a column layout
const LandingColumnLinks = exports.LandingColumnLinks = /*#__PURE__*/_react.default.memo(function LandingColumnLinks({
  items,
  urlState,
  onLinkClick
}) {
  const subLinkStyles = useSubLinkStyles();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    alignItems: "flexStart",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 7
    }
  }, items.map(subItem => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    key: subItem.id,
    grow: false,
    css: subLinkStyles.container,
    "data-test-subj": "LandingSubItem",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(LandingLink, {
    item: subItem,
    urlState: urlState,
    onLinkClick: onLinkClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 13
    }
  }, subItem.title))));
});