"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.workflowInsightsSubFeature = exports.trustedDevicesSubFeature = exports.trustedApplicationsSubFeature = exports.socManagementSubFeature = exports.scanActionSubFeature = exports.responseActionsHistorySubFeature = exports.processOperationsSubFeature = exports.policyManagementSubFeature = exports.hostIsolationSubFeature = exports.hostIsolationExceptionsBasicSubFeature = exports.globalArtifactManagementSubFeature = exports.fileOperationsSubFeature = exports.executeActionSubFeature = exports.eventFiltersSubFeature = exports.endpointListSubFeature = exports.endpointExceptionsSubFeature = exports.blocklistSubFeature = void 0;
var _i18n = require("@kbn/i18n");
var _securitysolutionListConstants = require("@kbn/securitysolution-list-constants");
var _constants = require("../constants");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const TRANSLATIONS = Object.freeze({
  all: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.allPrivilegeName', {
    defaultMessage: 'All'
  }),
  read: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.readPrivilegeName', {
    defaultMessage: 'Read'
  })
});
const endpointListSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint List access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList', {
    defaultMessage: 'Endpoint List'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointList.description', {
    defaultMessage: 'Displays all hosts running Elastic Defend and their relevant integration details.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeEndpointList`, `${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeEndpointList', 'readEndpointList']
    }, {
      api: [`${_constants.APP_ID}-readEndpointList`],
      id: 'endpoint_list_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEndpointList']
    }]
  }]
});
exports.endpointListSubFeature = endpointListSubFeature;
const trustedApplicationsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Trusted Applications access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications', {
    defaultMessage: 'Trusted Applications'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedApplications.description', {
    defaultMessage: 'Helps mitigate conflicts with other software, usually other antivirus or endpoint security applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeTrustedApplications`, `${_constants.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeTrustedApplications', 'readTrustedApplications']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readTrustedApplications`],
      id: 'trusted_applications_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readTrustedApplications']
    }]
  }]
});
exports.trustedApplicationsSubFeature = trustedApplicationsSubFeature;
const trustedDevicesSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedDevices.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Trusted Devices access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedDevices', {
    defaultMessage: 'Trusted Devices'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.trustedDevices.description', {
    defaultMessage: 'Manage security exceptions for USB and external devices.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeTrustedDevices`, `${_constants.APP_ID}-readTrustedDevices`],
      id: 'trusted_devices_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeTrustedDevices', 'readTrustedDevices']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readTrustedDevices`],
      id: 'trusted_devices_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readTrustedDevices']
    }]
  }]
});
exports.trustedDevicesSubFeature = trustedDevicesSubFeature;
const hostIsolationExceptionsBasicSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation Exceptions access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions', {
    defaultMessage: 'Host Isolation Exceptions'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolationExceptions.description', {
    defaultMessage: 'Add specific IP addresses that isolated hosts are still allowed to communicate with, even when isolated from the rest of the network.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-deleteHostIsolationExceptions`, `${_constants.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['readHostIsolationExceptions', 'deleteHostIsolationExceptions']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readHostIsolationExceptions`],
      id: 'host_isolation_exceptions_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readHostIsolationExceptions']
    }]
  }]
});
exports.hostIsolationExceptionsBasicSubFeature = hostIsolationExceptionsBasicSubFeature;
const blocklistSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Blocklist access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList', {
    defaultMessage: 'Blocklist'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.blockList.description', {
    defaultMessage: 'Extend Elastic Defend’s protection against malicious processes and protect against potentially harmful applications.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeBlocklist`, `${_constants.APP_ID}-readBlocklist`],
      id: 'blocklist_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeBlocklist', 'readBlocklist']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readBlocklist`],
      id: 'blocklist_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readBlocklist']
    }]
  }]
});
exports.blocklistSubFeature = blocklistSubFeature;
const eventFiltersSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Event Filters access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters', {
    defaultMessage: 'Event Filters'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.eventFilters.description', {
    defaultMessage: 'Filter out endpoint events that you do not need or want stored in Elasticsearch.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-writeEventFilters`, `${_constants.APP_ID}-readEventFilters`],
      id: 'event_filters_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['writeEventFilters', 'readEventFilters']
    }, {
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-readEventFilters`],
      id: 'event_filters_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readEventFilters']
    }]
  }]
});
exports.eventFiltersSubFeature = eventFiltersSubFeature;
const policyManagementSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Policy Management access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement', {
    defaultMessage: 'Elastic Defend Policy Management'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.policyManagement.description', {
    defaultMessage: 'Access the Elastic Defend integration policy to configure protections, event collection, and advanced policy features.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writePolicyManagement`, `${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: ['policy-settings-protection-updates-note'],
        read: []
      },
      ui: ['writePolicyManagement', 'readPolicyManagement']
    }, {
      api: [`${_constants.APP_ID}-readPolicyManagement`],
      id: 'policy_management_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: ['policy-settings-protection-updates-note']
      },
      ui: ['readPolicyManagement']
    }]
  }]
});
exports.policyManagementSubFeature = policyManagementSubFeature;
const responseActionsHistorySubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Response Actions History access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory', {
    defaultMessage: 'Response Actions History'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.responseActionsHistory.description', {
    defaultMessage: 'Access the history of response actions performed on endpoints.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeActionsLogManagement`, `${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeActionsLogManagement', 'readActionsLogManagement']
    }, {
      api: [`${_constants.APP_ID}-readActionsLogManagement`],
      id: 'actions_log_management_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readActionsLogManagement']
    }]
  }]
});
exports.responseActionsHistorySubFeature = responseActionsHistorySubFeature;
const hostIsolationSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Host Isolation access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation', {
    defaultMessage: 'Host Isolation'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.hostIsolation.description', {
    defaultMessage: 'Perform the "isolate" and "release" response actions.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeHostIsolationRelease`],
      id: 'host_isolation_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeHostIsolationRelease']
    }]
  }]
});
exports.hostIsolationSubFeature = hostIsolationSubFeature;
const processOperationsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Process Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations', {
    defaultMessage: 'Process Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.processOperations.description', {
    defaultMessage: 'Perform process-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeProcessOperations`],
      id: 'process_operations_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeProcessOperations']
    }]
  }]
});
exports.processOperationsSubFeature = processOperationsSubFeature;
const fileOperationsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for File Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations', {
    defaultMessage: 'File Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.fileOperations.description', {
    defaultMessage: 'Perform file-related response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeFileOperations`],
      id: 'file_operations_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeFileOperations']
    }]
  }]
});

// execute operations are not available in 8.7,
// but will be available in 8.8
exports.fileOperationsSubFeature = fileOperationsSubFeature;
const executeActionSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Execute Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations', {
    defaultMessage: 'Execute Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.executeOperations.description', {
    defaultMessage: 'Perform script execution response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeExecuteOperations`],
      id: 'execute_operations_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeExecuteOperations']
    }]
  }]
});

// 8.15 feature
exports.executeActionSubFeature = executeActionSubFeature;
const scanActionSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.scanOperations.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Scan Operations access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.scanOperations', {
    defaultMessage: 'Scan Operations'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.scanOperations.description', {
    defaultMessage: 'Perform folder scan response actions in the response console.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeScanOperations`],
      id: 'scan_operations_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeScanOperations']
    }]
  }]
});
exports.scanActionSubFeature = scanActionSubFeature;
const workflowInsightsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.workflowInsights.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Automatic Troubleshooting access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.workflowInsights', {
    defaultMessage: 'Automatic Troubleshooting'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.workflowInsights.description', {
    defaultMessage: 'Access to the automatic troubleshooting.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-writeWorkflowInsights`, `${_constants.APP_ID}-readWorkflowInsights`],
      id: 'workflow_insights_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['writeWorkflowInsights', 'readWorkflowInsights']
    }, {
      api: [`${_constants.APP_ID}-readWorkflowInsights`],
      id: 'workflow_insights_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['readWorkflowInsights']
    }]
  }]
});
exports.workflowInsightsSubFeature = workflowInsightsSubFeature;
const endpointExceptionsSubFeature = () => ({
  requireAllSpaces: true,
  privilegesTooltip: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions.privilegesTooltip', {
    defaultMessage: 'All Spaces is required for Endpoint Exceptions access.'
  }),
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions', {
    defaultMessage: 'Endpoint Exceptions'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.endpointExceptions.description', {
    defaultMessage: 'Reduce false positive alerts, and keep Elastic Defend from blocking standard processes.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      id: 'endpoint_exceptions_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [_securitysolutionListConstants.EXCEPTION_LIST_NAMESPACE_AGNOSTIC],
        read: []
      },
      ui: ['showEndpointExceptions', 'crudEndpointExceptions'],
      api: ['lists-all', 'lists-read', 'lists-summary', `${_constants.APP_ID}-showEndpointExceptions`, `${_constants.APP_ID}-crudEndpointExceptions`]
    }, {
      id: 'endpoint_exceptions_read',
      includeIn: 'none',
      name: TRANSLATIONS.read,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['showEndpointExceptions'],
      api: ['lists-read', 'lists-summary', `${_constants.APP_ID}-showEndpointExceptions`]
    }]
  }]
});

/**
 * Writing global (i.e. not per-policy) Artifacts is gated with `Global Artifact Management: ALL`, starting with `siemV3`.
 *
 * **Role migration implemented:**
 * Users, who have been able to write ANY artifact before, are now granted with this privilege to keep existing behavior.
 * - for Trusted Apps, Event Filters, Host Isolation Exceptions, Blocklists: the new privilege is added based on `artifact:ALL` sub-feature privilege
 * - for Endpoint Exceptions:
 *   - on Serverless offering, the new privilege is added for Endpoint Exceptions sub-privilege `ALL`,
 *   - on ESS offering, there is no EE sub-privilege, so the new privilege is added to `siem|siemV2:ALL|MINIMAL_ALL`,
 *     as these include the Endpoint Exceptions write privilege
 *
 */
exports.endpointExceptionsSubFeature = endpointExceptionsSubFeature;
const globalArtifactManagementSubFeature = experimentalFeatures => {
  const GLOBAL_ARTIFACT_MANAGEMENT = _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.globalArtifactManagement', {
    defaultMessage: 'Global Artifact Management'
  });
  return {
    requireAllSpaces: false,
    privilegesTooltip: undefined,
    name: GLOBAL_ARTIFACT_MANAGEMENT,
    description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.globalArtifactManagement.description', {
      defaultMessage: 'Manage global assignment of endpoint artifacts (e.g., Trusted Applications, Event Filters) ' + 'across all policies. This privilege controls global assignment rights only; privileges for each ' + 'artifact type are required for full artifact management.'
    }),
    privilegeGroups: [{
      groupType: 'mutually_exclusive',
      privileges: [{
        api: [`${_constants.APP_ID}-writeGlobalArtifacts`],
        id: 'global_artifact_management_all',
        includeIn: 'none',
        name: TRANSLATIONS.all,
        savedObject: {
          all: [],
          read: []
        },
        ui: ['writeGlobalArtifacts']
      }]
    }]
  };
};
exports.globalArtifactManagementSubFeature = globalArtifactManagementSubFeature;
const socManagementSubFeature = () => ({
  requireAllSpaces: false,
  privilegesTooltip: undefined,
  name: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.socManagement', {
    defaultMessage: 'SOC Management'
  }),
  description: _i18n.i18n.translate('securitySolutionPackages.features.featureRegistry.subFeatures.socManagement.description', {
    defaultMessage: 'Access to SOC management capabilities including AI value reporting and analytics.'
  }),
  privilegeGroups: [{
    groupType: 'mutually_exclusive',
    privileges: [{
      api: [`${_constants.APP_ID}-socManagement`],
      id: 'soc_management_all',
      includeIn: 'none',
      name: TRANSLATIONS.all,
      savedObject: {
        all: [],
        read: []
      },
      ui: ['socManagement']
    }]
  }]
});
exports.socManagementSubFeature = socManagementSubFeature;