"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDelete = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _reactKibanaMount = require("@kbn/react-kibana-mount");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/roles_grid/confirm_delete/confirm_delete.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ConfirmDelete extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onConfirmDelete", () => {
      this.setState({
        deleteInProgress: true
      }, () => {
        this.deleteRoles();
      });
    });
    (0, _defineProperty2.default)(this, "deleteRoles", async () => {
      const {
        rolesToDelete,
        callback,
        rolesAPIClient,
        notifications,
        buildFlavor
      } = this.props;
      const errors = [];
      const deleteOperations = rolesToDelete.map(roleName => {
        const deleteRoleTask = async () => {
          try {
            await rolesAPIClient.deleteRole(roleName);
            if (buildFlavor === 'traditional') {
              notifications.toasts.addSuccess(_i18n.i18n.translate('xpack.security.management.roles.confirmDelete.roleSuccessfullyDeletedNotificationMessage', {
                defaultMessage: 'Deleted role {roleName}',
                values: {
                  roleName
                }
              }));
            }
          } catch (e) {
            errors.push(roleName);
            notifications.toasts.addDanger(_i18n.i18n.translate('xpack.security.management.roles.confirmDelete.roleDeletingErrorNotificationMessage', {
              defaultMessage: 'Error deleting role {roleName}',
              values: {
                roleName
              }
            }));
          }
        };
        return deleteRoleTask();
      });
      await Promise.all(deleteOperations);
      if (buildFlavor === 'serverless') {
        this.props.notifications.toasts.addDanger({
          title: _i18n.i18n.translate('xpack.security.management.roles.deleteRolesSuccessTitle', {
            defaultMessage: '{numberOfCustomRoles, plural, one {# custom role} other {# custom roles}} deleted',
            values: {
              numberOfCustomRoles: deleteOperations.length
            }
          }),
          text: (0, _reactKibanaMount.toMountPoint)(/*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 203,
              columnNumber: 13
            }
          }, _i18n.i18n.translate('xpack.security.management.roles.deleteRolesSuccessMessage', {
            defaultMessage: `The deleted role will still appear listed on the user profile in Organization
                  Management and on the User Profile for those that don't have admin access.`
          })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
            justifyContent: "flexEnd",
            gutterSize: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 210,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
            grow: false,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 211,
              columnNumber: 15
            }
          }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
            size: "s",
            href: this.props.cloudOrgUrl,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 212,
              columnNumber: 17
            }
          }, "Manage Members")))), this.props)
        });
      }
      callback(rolesToDelete, errors);
    });
    this.state = {
      deleteInProgress: false
    };
  }
  render() {
    const {
      rolesToDelete,
      buildFlavor
    } = this.props;
    const moreThanOne = rolesToDelete.length > 1;
    const modalTitleId = (0, _eui.htmlIdGenerator)()('confirmDeleteModalTitle');
    const title = _i18n.i18n.translate('xpack.security.management.roles.deleteRoleTitle', {
      defaultMessage: `Delete role{value, plural, one {{roleName}} other {s}}?`,
      values: {
        value: rolesToDelete.length,
        roleName: ` ${rolesToDelete[0]}`
      }
    });

    // This is largely the same as the built-in EuiConfirmModal component, but we needed the ability
    // to disable the buttons since this could be a long-running operation

    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      onClose: this.props.onCancel,
      "aria-labelledby": modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 68,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 69,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      "data-test-subj": "confirmModalTitleText",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 11
      }
    }, title)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 74,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 75,
        columnNumber: 11
      }
    }, moreThanOne ? /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 77,
        columnNumber: 15
      }
    }, buildFlavor === 'traditional' && /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 79,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.removingRolesDescription",
      defaultMessage: "You are about to delete these roles:",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 80,
        columnNumber: 21
      }
    })), buildFlavor === 'serverless' && /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.serverless.removingRolesDescription",
      defaultMessage: "Users with the following roles assigned may lose access to the project if they are not assigned any other roles:",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 21
      }
    })), /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 94,
        columnNumber: 17
      }
    }, rolesToDelete.map(roleName => /*#__PURE__*/_react.default.createElement("li", {
      key: roleName,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 21
      }
    }, roleName)))) : /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 15
      }
    }, buildFlavor === 'serverless' && /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 19
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.serverless.removingSingleRoleDescription",
      defaultMessage: "Users with the {roleName} role assigned may lose access to the project if they are not assigned any other roles.",
      values: {
        roleName: rolesToDelete[0]
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 21
      }
    }))), buildFlavor === 'traditional' && /*#__PURE__*/_react.default.createElement("p", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 114,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.deletingRolesWarningMessage",
      defaultMessage: "You can't undo this operation.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 115,
        columnNumber: 17
      }
    })))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 123,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "confirmModalCancelButton",
      onClick: this.props.onCancel,
      isDisabled: this.state.deleteInProgress,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 124,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 129,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "confirmModalConfirmButton",
      onClick: this.onConfirmDelete,
      fill: true,
      color: 'danger',
      isLoading: this.state.deleteInProgress,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.roles.confirmDelete.deleteButtonLabel",
      defaultMessage: "Delete",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 142,
        columnNumber: 13
      }
    }))));
  }
}
exports.ConfirmDelete = ConfirmDelete;