"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IndexPrivileges = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _index_privilege_form = require("./index_privilege_form");
var _model = require("../../../../../../common/model");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/management/roles/edit_role/privileges/es/index_privileges.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class IndexPrivileges extends _react.Component {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "addIndexPrivilege", () => {
      var _role$elasticsearch$i;
      const {
        role,
        indexType
      } = this.props;
      const indices = (_role$elasticsearch$i = role.elasticsearch[indexType]) !== null && _role$elasticsearch$i !== void 0 ? _role$elasticsearch$i : [];
      const newIndices = [...indices, {
        names: [],
        privileges: [],
        field_security: {
          grant: ['*']
        }
      }];
      this.props.onChange({
        ...this.props.role,
        elasticsearch: {
          ...this.props.role.elasticsearch,
          [indexType]: newIndices
        }
      });
    });
    (0, _defineProperty2.default)(this, "onIndexPrivilegeChange", privilegeIndex => {
      return updatedPrivilege => {
        var _role$elasticsearch$i2;
        const {
          role,
          indexType
        } = this.props;
        const indices = (_role$elasticsearch$i2 = role.elasticsearch[indexType]) !== null && _role$elasticsearch$i2 !== void 0 ? _role$elasticsearch$i2 : [];
        const newIndices = [...indices];
        newIndices[privilegeIndex] = updatedPrivilege;
        this.props.onChange({
          ...this.props.role,
          elasticsearch: {
            ...this.props.role.elasticsearch,
            [indexType]: newIndices
          }
        });
      };
    });
    (0, _defineProperty2.default)(this, "onIndexPrivilegeDelete", privilegeIndex => {
      return () => {
        var _role$elasticsearch$i3;
        const {
          role,
          indexType
        } = this.props;
        const indices = (_role$elasticsearch$i3 = role.elasticsearch[indexType]) !== null && _role$elasticsearch$i3 !== void 0 ? _role$elasticsearch$i3 : [];
        const newIndices = [...indices];
        newIndices.splice(privilegeIndex, 1);
        this.props.onChange({
          ...this.props.role,
          elasticsearch: {
            ...this.props.role.elasticsearch,
            [indexType]: newIndices
          }
        });
      };
    });
    (0, _defineProperty2.default)(this, "isPlaceholderPrivilege", indexPrivilege => {
      return indexPrivilege.names.length === 0;
    });
    this.state = {
      availableFields: {}
    };
  }
  render() {
    var _this$props$role$elas;
    const indices = (_this$props$role$elas = this.props.role.elasticsearch[this.props.indexType]) !== null && _this$props$role$elas !== void 0 ? _this$props$role$elas : [];
    const {
      indexPatterns = [],
      remoteClusters,
      license,
      availableIndexPrivileges,
      indicesAPIClient
    } = this.props;
    const {
      allowRoleDocumentLevelSecurity,
      allowRoleFieldLevelSecurity,
      allowRoleRemoteIndexPrivileges
    } = license.getFeatures();
    const remoteIndexPrivilegesDisabled = this.props.indexType === 'remote_indices' && !allowRoleRemoteIndexPrivileges;
    const props = {
      indexType: this.props.indexType,
      indexPatterns,
      indicesAPIClient,
      // If editing an existing role while that has been disabled, always show the FLS/DLS fields because currently
      // a role is only marked as disabled if it has FLS/DLS setup (usually before the user changed to a license that
      // doesn't permit FLS/DLS).
      allowDocumentLevelSecurity: allowRoleDocumentLevelSecurity || !(0, _model.isRoleEnabled)(this.props.role),
      allowFieldLevelSecurity: allowRoleFieldLevelSecurity || !(0, _model.isRoleEnabled)(this.props.role),
      isRoleReadOnly: !this.props.editable || (0, _model.isRoleReadOnly)(this.props.role) || remoteIndexPrivilegesDisabled
    };
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 7
      }
    }, indices.map((indexPrivilege, i) => /*#__PURE__*/_react.default.createElement(_index_privilege_form.IndexPrivilegeForm, (0, _extends2.default)({
      key: i
    }, props, {
      formIndex: i,
      validator: this.props.validator,
      availableIndexPrivileges: availableIndexPrivileges,
      indexPrivilege: indexPrivilege,
      remoteClusters: remoteClusters,
      onChange: this.onIndexPrivilegeChange(i),
      onDelete: this.onIndexPrivilegeDelete(i),
      isDarkMode: this.props.isDarkMode,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 11
      }
    }))), this.props.editable && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      alignItems: "center",
      gutterSize: "s",
      responsive: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 104,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 105,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "plusInCircle",
      onClick: this.addIndexPrivilege,
      disabled: remoteIndexPrivilegesDisabled,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 106,
        columnNumber: 17
      }
    }, this.props.indexType === 'remote_indices' ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.elasticSearchPrivileges.addRemoteIndexPrivilegesButtonLabel",
      defaultMessage: "Add remote index privilege",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 112,
        columnNumber: 21
      }
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.management.editRole.elasticSearchPrivileges.addIndexPrivilegesButtonLabel",
      defaultMessage: "Add index privilege",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 117,
        columnNumber: 21
      }
    }))), remoteIndexPrivilegesDisabled && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 125,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
      content: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.security.management.editRole.elasticSearchPrivileges.remoteIndexPrivilegesLicenseMissing",
        defaultMessage: "Your license does not allow configuring remote index privileges",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 128,
          columnNumber: 23
        }
      }),
      position: "right",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 126,
        columnNumber: 19
      }
    })))));
  }
}
exports.IndexPrivileges = IndexPrivileges;
(0, _defineProperty2.default)(IndexPrivileges, "defaultProps", {
  editable: true
});