"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useElasticsearchQuery = void 0;
var _reactQuery = require("@kbn/react-query");
var _reactHookForm = require("react-hook-form");
var _common = require("../../common");
var _types = require("../types");
var _user_query = require("../utils/user_query");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useElasticsearchQuery = pageMode => {
  const {
    http
  } = (0, _use_kibana.useKibana)().services;
  const {
    getValues,
    formState: {
      errors: formErrors
    }
  } = (0, _reactHookForm.useFormContext)();
  const executeEsQuery = () => {
    const formValues = getValues();
    const esQuery = (0, _user_query.elasticsearchQueryString)(formValues[_types.PlaygroundFormFields.elasticsearchQuery], formValues[_types.PlaygroundFormFields.userElasticsearchQuery], formErrors[_types.PlaygroundFormFields.userElasticsearchQuery]);
    const body = pageMode === _types.PlaygroundPageMode.chat ? JSON.stringify({
      elasticsearch_query: esQuery,
      indices: formValues[_types.PlaygroundFormFields.indices],
      query: formValues[_types.PlaygroundFormFields.question],
      chat_context: {
        source_fields: JSON.stringify(formValues[_types.PlaygroundFormFields.sourceFields]),
        doc_size: formValues[_types.PlaygroundFormFields.docSize]
      }
    }) : JSON.stringify({
      elasticsearch_query: esQuery,
      indices: formValues[_types.PlaygroundFormFields.indices],
      query: formValues[_types.PlaygroundFormFields.searchQuery]
    });
    return http.post(_types.APIRoutes.POST_QUERY_TEST, {
      body
    });
  };
  const {
    refetch: executeQuery,
    ...rest
  } = (0, _reactQuery.useQuery)({
    queryKey: [_common.SearchPlaygroundQueryKeys.SearchQueryTest],
    queryFn: executeEsQuery,
    enabled: false,
    retry: false
  });
  return {
    executeQuery,
    ...rest
  };
};
exports.useElasticsearchQuery = useElasticsearchQuery;