"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LanguageSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_asset_base_path = require("../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/shared/language_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const LanguageSelector = ({
  selectedLanguage,
  options,
  onSelectLanguage,
  showLabel = false
}) => {
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const languageOptions = (0, _react.useMemo)(() => options.map(lang => ({
    value: lang.id,
    'aria-label': _i18n.i18n.translate('xpack.searchIndices.codeLanguage.selectChangeAriaLabel', {
      defaultMessage: 'Change language of code examples to {language} for every instance on this page',
      values: {
        language: lang.title
      }
    }),
    'data-test-subj': `lang-option-${lang.id}`,
    inputDisplay: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 43,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: `${assetBasePath}/${lang.icon}`,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 44,
        columnNumber: 13
      }
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 45,
        columnNumber: 13
      }
    }, lang.title))
  })), [assetBasePath, options]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiSuperSelect, {
    prepend: showLabel ? _i18n.i18n.translate('xpack.searchIndices.codeLanguage.selectLabel', {
      defaultMessage: 'Language'
    }) : undefined,
    "aria-label": _i18n.i18n.translate('xpack.searchIndices.codeLanguage.selectLabel', {
      defaultMessage: 'Select a programming language for the code examples'
    }),
    options: languageOptions,
    valueOfSelected: selectedLanguage,
    onChange: value => onSelectLanguage(value),
    "data-test-subj": "codeExampleLanguageSelect",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 5
    }
  });
};
exports.LanguageSelector = LanguageSelector;