"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useSearchGettingStartedFeatureFlag = void 0;
var _feature_flags = require("../utils/feature_flags");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * React hook to check if the Getting Started feature is enabled.
 * Default to false if the feature flag is not set or the feature flags service is not available.
 *
 * @returns boolean indicating if the feature is enabled
 */
const useSearchGettingStartedFeatureFlag = () => {
  const {
    featureFlags
  } = (0, _use_kibana.useKibana)().services;
  return featureFlags ? (0, _feature_flags.isGettingStartedEnabled)(featureFlags) : false;
};
exports.useSearchGettingStartedFeatureFlag = useSearchGettingStartedFeatureFlag;