"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchHomepagePage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _i18n = require("@kbn/i18n");
var _connection_details = require("@kbn/cloud/connection_details");
var _use_kibana = require("../../hooks/use_kibana");
var _search_homepage_body = require("./search_homepage_body");
var _promo_banner = require("./promo_banner");
var _use_get_license_info = require("../../hooks/use_get_license_info");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_homepage/public/components/search_homepage/search_homepage.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SearchHomepagePage = () => {
  const {
    services: {
      console: consolePlugin,
      history,
      searchNavigation,
      security
    }
  } = (0, _use_kibana.useKibana)();
  const [username, setUsername] = (0, _react.useState)('');
  (0, _react.useEffect)(() => {
    const getUser = async () => {
      const user = await (security === null || security === void 0 ? void 0 : security.authc.getCurrentUser());
      setUsername((user === null || user === void 0 ? void 0 : user.username) || '');
    };
    getUser();
  }, [security]);
  (0, _react.useEffect)(() => {
    if (searchNavigation) {
      searchNavigation.breadcrumbs.setSearchBreadCrumbs([{
        text: _i18n.i18n.translate('xpack.searchHomepage.breadcrumbs.home', {
          defaultMessage: 'Home'
        })
      }]);
    }
  }, [searchNavigation]);
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 51,
      columnNumber: 47
    }
  }) : null, [consolePlugin]);
  const {
    isTrial,
    daysLeft
  } = (0, _use_get_license_info.useGetLicenseInfo)();
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: true,
    "data-test-subj": "search-homepage",
    grow: false,
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_promo_banner.PromoBanner, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 64,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    restrictWidth: true,
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 65,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 66,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 67,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 68,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 69,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    alignItems: "center",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 70,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 23
    }
  }, username ? _i18n.i18n.translate('xpack.searchHomepage.welcome.title', {
    defaultMessage: 'Welcome, {username}',
    values: {
      username
    }
  }) : _i18n.i18n.translate('xpack.searchHomepage.welcome.title.default', {
    defaultMessage: 'Welcome'
  })))), isTrial && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 21
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiBetaBadge, {
    title: "",
    color: "subdued",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.searchHomepage.searchHomepagePage.trialBadgeLabel",
      defaultMessage: "Trial",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 91,
        columnNumber: 27
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 23
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: "plugs",
    iconSide: "left",
    onClick: () => (0, _connection_details.openWiredConnectionDetails)(),
    "data-test-subj": "search-homepage-context-menu-button",
    color: "text",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 17
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.connectionDetails.buttonLabel', {
    defaultMessage: 'Connection details'
  }))))), isTrial && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 17
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 19
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 122,
      columnNumber: 21
    }
  }, _i18n.i18n.translate('xpack.searchHomepage.searchHomepagePage.p.youHaveLabel', {
    defaultMessage: 'You have {daysLeft} days remaining your trial.',
    values: {
      daysLeft
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 17
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_search_homepage_body.SearchHomepageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 140,
      columnNumber: 7
    }
  }), embeddableConsole);
};
exports.SearchHomepagePage = SearchHomepagePage;