"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CronEditor = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _constants = require("./constants");
var _cron_daily = require("./cron_daily");
var _cron_hourly = require("./cron_hourly");
var _cron_minutely = require("./cron_minutely");
var _cron_monthly = require("./cron_monthly");
var _cron_weekly = require("./cron_weekly");
var _cron_yearly = require("./cron_yearly");
var _services = require("./services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/packages/shared/kbn-search-connectors/components/cron_editor/cron_editor.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const excludeBlockListedFrequencies = (units, blockListedUnits = []) => {
  if (blockListedUnits.length === 0) {
    return units;
  }
  return units.filter(({
    value
  }) => !blockListedUnits.includes(value));
};
class CronEditor extends _react.Component {
  static getDerivedStateFromProps(props) {
    const {
      cronExpression
    } = props;
    return (0, _services.cronExpressionToParts)(cronExpression);
  }
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "onChangeFrequency", frequency => {
      const {
        onChange,
        fieldToPreferredValueMap
      } = this.props;

      // Update fields which aren't editable with acceptable baseline values.
      const editableFields = Object.keys(_constants.frequencyToFieldsMap[frequency]);
      const inheritedFields = editableFields.reduce((fieldBaselines, field) => {
        if (fieldToPreferredValueMap[field] != null) {
          fieldBaselines[field] = fieldToPreferredValueMap[field];
        }
        return fieldBaselines;
      }, {
        ..._constants.frequencyToBaselineFieldsMap[frequency]
      });
      const newCronExpression = (0, _services.cronPartsToExpression)(inheritedFields);
      onChange({
        frequency,
        cronExpression: newCronExpression,
        fieldToPreferredValueMap
      });
    });
    (0, _defineProperty2.default)(this, "onChangeFields", fields => {
      const {
        onChange,
        frequency,
        fieldToPreferredValueMap
      } = this.props;
      const editableFields = Object.keys(_constants.frequencyToFieldsMap[frequency]);
      const newFieldToPreferredValueMap = {};
      const editedFields = editableFields.reduce((accumFields, field) => {
        if (fields[field] !== undefined) {
          accumFields[field] = fields[field];
          // If the user changes a field's value, we want to maintain that value in the relevant
          // field, even as the frequency field changes. For example, if the user selects "Monthly"
          // frequency and changes the "Hour" field to "10", that field should still say "10" if the
          // user changes the frequency to "Weekly". We'll support this UX by storing these values
          // in the fieldToPreferredValueMap.
          newFieldToPreferredValueMap[field] = fields[field];
        } else {
          accumFields[field] = this.state[field];
        }
        return accumFields;
      }, {
        ..._constants.frequencyToBaselineFieldsMap[frequency]
      });
      const newCronExpression = (0, _services.cronPartsToExpression)(editedFields);
      onChange({
        frequency,
        cronExpression: newCronExpression,
        fieldToPreferredValueMap: {
          ...fieldToPreferredValueMap,
          ...newFieldToPreferredValueMap
        }
      });
    });
    const {
      cronExpression
    } = props;
    const parsedCron = (0, _services.cronExpressionToParts)(cronExpression);
    this.state = {
      ...parsedCron
    };
  }
  renderForm() {
    const {
      frequency,
      disabled
    } = this.props;
    const {
      minute,
      hour,
      day,
      date,
      month
    } = this.state;
    switch (frequency) {
      case 'MINUTE':
        return /*#__PURE__*/_react.default.createElement(_cron_minutely.CronMinutely, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.EVERY_MINUTE_OPTIONS,
          onChange: this.onChangeFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 152,
            columnNumber: 11
          }
        });
      case 'HOUR':
        return /*#__PURE__*/_react.default.createElement(_cron_hourly.CronHourly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          onChange: this.onChangeFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 162,
            columnNumber: 11
          }
        });
      case 'DAY':
        return /*#__PURE__*/_react.default.createElement(_cron_daily.CronDaily, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          onChange: this.onChangeFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 172,
            columnNumber: 11
          }
        });
      case 'WEEK':
        return /*#__PURE__*/_react.default.createElement(_cron_weekly.CronWeekly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          day: day,
          dayOptions: _constants.DAY_OPTIONS,
          onChange: this.onChangeFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 184,
            columnNumber: 11
          }
        });
      case 'MONTH':
        return /*#__PURE__*/_react.default.createElement(_cron_monthly.CronMonthly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          date: date,
          dateOptions: _constants.DATE_OPTIONS,
          onChange: this.onChangeFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 198,
            columnNumber: 11
          }
        });
      case 'YEAR':
        return /*#__PURE__*/_react.default.createElement(_cron_yearly.CronYearly, {
          disabled: disabled,
          minute: minute,
          minuteOptions: _constants.MINUTE_OPTIONS,
          hour: hour,
          hourOptions: _constants.HOUR_OPTIONS,
          date: date,
          dateOptions: _constants.DATE_OPTIONS,
          month: month,
          monthOptions: _constants.MONTH_OPTIONS,
          onChange: this.onChangeFields,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 212,
            columnNumber: 11
          }
        });
      default:
        return;
    }
  }
  render() {
    const {
      disabled,
      frequency,
      frequencyBlockList
    } = this.props;
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 235,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "searchConnectors.cronEditor.fieldFrequencyLabel",
        defaultMessage: "Frequency",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 238,
          columnNumber: 13
        }
      }),
      fullWidth: true,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 236,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
      disabled: disabled,
      autoFocus: this.props.autoFocus,
      options: excludeBlockListedFrequencies(_constants.UNITS, frequencyBlockList),
      value: frequency,
      onChange: e => this.onChangeFrequency(e.target.value),
      fullWidth: true,
      prepend: _i18n.i18n.translate('searchConnectors.cronEditor.textEveryLabel', {
        defaultMessage: 'Every'
      }),
      "data-test-subj": "cronFrequencySelect",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 245,
        columnNumber: 11
      }
    })), this.renderForm());
  }
}
exports.CronEditor = CronEditor;