"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScreenshottingPlugin = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _common = require("../common");
var _app = require("./app");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/screenshotting/public/plugin.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class ScreenshottingPlugin {
  setup({
    application
  }, {
    screenshotMode
  }) {
    if (screenshotMode.isScreenshotMode()) {
      application.register({
        id: _common.SCREENSHOTTING_APP_ID,
        title: 'Screenshotting Expressions Renderer',
        visibleIn: [],
        chromeless: true,
        mount: async ({
          element
        }) => {
          _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_app.ScreenshotModeContext.Provider, {
            value: screenshotMode,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 31,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_app.App, {
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 32,
              columnNumber: 15
            }
          })), element);
          return () => _reactDom.default.unmountComponentAtNode(element);
        }
      });
    }
  }
  start() {}
  stop() {}
}
exports.ScreenshottingPlugin = ScreenshottingPlugin;