"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectSaveModalWithSaveResult = exports.SavedObjectSaveModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects/public/save_modal/saved_object_save_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
const generateId = (0, _eui.htmlIdGenerator)();

/**
 * @deprecated
 * @removeBy 8.8.0
 */
class SavedObjectSaveModalComponent extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "warning", /*#__PURE__*/_react.default.createRef());
    (0, _defineProperty2.default)(this, "formId", generateId('form'));
    (0, _defineProperty2.default)(this, "state", {
      title: this.props.title,
      copyOnSave: Boolean(this.props.initialCopyOnSave),
      isTitleDuplicateConfirmed: false,
      hasTitleDuplicate: false,
      isSaving: false,
      visualizationDescription: this.props.description ? this.props.description : '',
      hasAttemptedSubmit: false
    });
    (0, _defineProperty2.default)(this, "renderViewDescription", () => {
      if (!this.props.showDescription) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        fullWidth: true,
        labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
          size: "xs",
          color: "subdued",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 232,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.optional",
          defaultMessage: "Optional",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 233,
            columnNumber: 13
          }
        })),
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.descriptionLabel",
          defaultMessage: "Description",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 237,
            columnNumber: 11
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 229,
          columnNumber: 7
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiTextArea, {
        fullWidth: true,
        "data-test-subj": "savedObjectDescription",
        value: this.state.visualizationDescription,
        onChange: this.onDescriptionChange,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 243,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "onDescriptionChange", event => {
      this.setState({
        visualizationDescription: event.target.value
      });
    });
    (0, _defineProperty2.default)(this, "onTitleDuplicate", () => {
      this.setState({
        isSaving: false,
        isTitleDuplicateConfirmed: true,
        hasTitleDuplicate: true
      });
      if (this.warning.current) {
        this.warning.current.focus();
      }
    });
    (0, _defineProperty2.default)(this, "saveSavedObject", async () => {
      if (this.state.isSaving) return;
      this.setState({
        isSaving: true
      });
      try {
        await this.props.onSave({
          newTitle: this.state.title,
          newCopyOnSave: Boolean(this.props.mustCopyOnSaveMessage) || this.state.copyOnSave,
          isTitleDuplicateConfirmed: this.state.isTitleDuplicateConfirmed,
          onTitleDuplicate: this.onTitleDuplicate,
          newDescription: this.state.visualizationDescription
        });
      } finally {
        this.setState({
          isSaving: false
        });
      }
    });
    (0, _defineProperty2.default)(this, "onTitleChange", event => {
      this.setState({
        title: event.target.value,
        isTitleDuplicateConfirmed: false,
        hasTitleDuplicate: false
      });
    });
    (0, _defineProperty2.default)(this, "handleTitleDuplication", () => {
      const regex = /\s*\[(\d+)\]$/;
      const match = this.state.title.match(regex);
      if (match) {
        const newNumber = Number(match[1]) + 1;
        this.setState({
          title: this.state.title.replace(regex, ` [${newNumber}]`)
        });
      } else {
        this.setState({
          title: this.state.title + ' [1]'
        });
      }
    });
    (0, _defineProperty2.default)(this, "onCopyOnSaveChange", event => {
      if (this.props.title === this.state.title && event.target.checked) {
        this.handleTitleDuplication();
      }
      this.setState({
        copyOnSave: event.target.checked
      });
      if (this.props.onCopyOnSaveChange) {
        this.props.onCopyOnSaveChange(event.target.checked);
      }
    });
    (0, _defineProperty2.default)(this, "onFormSubmit", event => {
      event.preventDefault();
      const {
        hasAttemptedSubmit,
        title
      } = this.state;
      if (!hasAttemptedSubmit) {
        this.setState({
          hasAttemptedSubmit: true
        });
      }
      const isValid = this.props.isValid !== undefined ? this.props.isValid : true;
      if (title.length !== 0 && isValid) {
        this.saveSavedObject();
      }
    });
    (0, _defineProperty2.default)(this, "renderConfirmButton", () => {
      const {
        isSaving
      } = this.state;
      let confirmLabel = _i18n.i18n.translate('savedObjects.saveModal.saveButtonLabel', {
        defaultMessage: 'Save'
      });
      if (this.props.confirmButtonLabel) {
        confirmLabel = this.props.confirmButtonLabel;
      }
      return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        fill: true,
        "data-test-subj": "confirmSaveSavedObjectButton",
        isLoading: isSaving,
        type: "submit",
        form: this.formId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 361,
          columnNumber: 7
        }
      }, confirmLabel);
    });
    (0, _defineProperty2.default)(this, "renderDuplicateTitleCallout", duplicateWarningId => {
      if (!this.state.hasTitleDuplicate) {
        return;
      }
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("div", {
        ref: this.warning,
        tabIndex: -1,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 380,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCallOut, {
        title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.duplicateTitleLabel",
          defaultMessage: "This {objectType} already exists",
          values: {
            objectType: this.props.objectType
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 383,
            columnNumber: 15
          }
        }),
        color: "warning",
        "data-test-subj": "titleDuplicateWarnMsg",
        id: duplicateWarningId,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 381,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 393,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjects.saveModal.duplicateTitleDescription",
        defaultMessage: "Saving ''{title}'' creates a duplicate title.",
        values: {
          title: this.state.title
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 394,
          columnNumber: 15
        }
      })))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 404,
          columnNumber: 9
        }
      }));
    });
    (0, _defineProperty2.default)(this, "renderCopyOnSave", () => {
      return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 412,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        "data-test-subj": "saveAsNewCheckbox",
        checked: Boolean(this.props.mustCopyOnSaveMessage) || this.state.copyOnSave,
        disabled: Boolean(this.props.mustCopyOnSaveMessage),
        onChange: this.onCopyOnSaveChange,
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjects.saveModal.saveAsNewLabel",
          defaultMessage: "Save as new {objectType}",
          values: {
            objectType: this.props.objectType
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 419,
            columnNumber: 15
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 413,
          columnNumber: 11
        }
      })), this.props.mustCopyOnSaveMessage && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        css: ({
          euiTheme
        }) => ({
          marginLeft: `-${euiTheme.size.base}`
        }),
        grow: false,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 428,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        type: "info",
        content: this.props.mustCopyOnSaveMessage,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 432,
          columnNumber: 13
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 435,
          columnNumber: 9
        }
      }));
    });
  }
  render() {
    const {
      theme
    } = this.props;
    const {
      isTitleDuplicateConfirmed,
      hasTitleDuplicate,
      title,
      hasAttemptedSubmit
    } = this.state;
    const duplicateWarningId = generateId();
    const modalTitleId = generateId('saveModal');
    const hasColumns = !!this.props.rightOptions;
    const titleInputValid = hasAttemptedSubmit && (!isTitleDuplicateConfirmed && hasTitleDuplicate || title.length === 0);
    const formBodyContent = /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      fullWidth: true,
      label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjects.saveModal.titleLabel",
        defaultMessage: "Title",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 129,
          columnNumber: 18
        }
      }),
      isInvalid: titleInputValid,
      error: _i18n.i18n.translate('savedObjects.saveModal.titleRequired', {
        defaultMessage: 'A title is required'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 127,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      fullWidth: true,
      "data-test-subj": "savedObjectTitle",
      value: title,
      onChange: this.onTitleChange,
      isInvalid: titleInputValid,
      "aria-describedby": this.state.hasTitleDuplicate ? duplicateWarningId : undefined,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 135,
        columnNumber: 11
      }
    })), this.renderViewDescription(), typeof this.props.options === 'function' ? this.props.options(this.state) : this.props.options);
    const formBody = hasColumns ? /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "m",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 154,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 155,
        columnNumber: 9
      }
    }, formBodyContent), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 156,
        columnNumber: 9
      }
    }, typeof this.props.rightOptions === 'function' ? this.props.rightOptions(this.state) : this.props.rightOptions)) : formBodyContent;
    const styles = (0, _react2.css)({
      width: hasColumns ? (0, _eui.mathWithUnits)(theme.euiTheme.size.xxl, x => x * 20) : (0, _eui.mathWithUnits)(theme.euiTheme.size.xxl, x => x * 15)
    });
    return /*#__PURE__*/_react.default.createElement(_eui.EuiModal, {
      "data-test-subj": "savedObjectSaveModal",
      onClose: this.props.onClose,
      css: styles,
      "aria-labelledby": modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeader, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiModalHeaderTitle, {
      id: modalTitleId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 179,
        columnNumber: 11
      }
    }, this.props.customModalTitle ? this.props.customModalTitle : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjects.saveModal.saveTitle",
      defaultMessage: "Save {objectType}",
      values: {
        objectType: this.props.objectType
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 15
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiModalBody, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 192,
        columnNumber: 9
      }
    }, this.renderDuplicateTitleCallout(duplicateWarningId), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
      component: "form",
      onSubmit: this.onFormSubmit,
      id: this.formId,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 195,
        columnNumber: 11
      }
    }, !this.props.showDescription && this.props.description && /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s",
      color: "subdued",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 197,
        columnNumber: 15
      }
    }, this.props.description), formBody)), /*#__PURE__*/_react.default.createElement(_eui.EuiModalFooter, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 205,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      justifyContent: "flexEnd",
      alignItems: "center",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 206,
        columnNumber: 11
      }
    }, this.props.showCopyOnSave && this.renderCopyOnSave(), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "saveCancelButton",
      onClick: this.props.onClose,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 209,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjects.saveModal.cancelButtonLabel",
      defaultMessage: "Cancel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 210,
        columnNumber: 17
      }
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 216,
        columnNumber: 13
      }
    }, this.renderConfirmButton()))));
  }
}

/**
 * @deprecated
 */
const SavedObjectSaveModal = exports.SavedObjectSaveModal = (0, _eui.withEuiTheme)(SavedObjectSaveModalComponent);

/**
 * This is a workaround for using this directly with the `showSaveModal` method.
 *
 * The `showSaveModal` method wraps and calls these props from outside but this modal
 * does not require the `SaveResult` to be returned from `onSave`.
 *
 * @deprecated
 */
const SavedObjectSaveModalWithSaveResult = exports.SavedObjectSaveModalWithSaveResult = (0, _eui.withEuiTheme)(SavedObjectSaveModalComponent);