"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Table = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _moment = _interopRequireDefault(require("moment"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _lib = require("../../../lib");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/src/platform/plugins/shared/saved_objects_management/public/management_section/objects_table/components/table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const MAX_PAGINATED_ITEM = 10000;
class Table extends _react.PureComponent {
  constructor(props) {
    super(props);
    (0, _defineProperty2.default)(this, "state", {
      isSearchTextValid: true,
      parseErrorMessage: null,
      isExportPopoverOpen: false,
      isIncludeReferencesDeepChecked: true,
      activeAction: undefined
    });
    (0, _defineProperty2.default)(this, "onChange", ({
      query,
      error
    }) => {
      if (error) {
        this.setState({
          isSearchTextValid: false,
          parseErrorMessage: error.message
        });
        return;
      }
      this.setState({
        isSearchTextValid: true,
        parseErrorMessage: null
      });
      this.props.onQueryChange({
        query
      });
    });
    (0, _defineProperty2.default)(this, "closeExportPopover", () => {
      this.setState({
        isExportPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "toggleExportPopoverVisibility", () => {
      this.setState(state => ({
        isExportPopoverOpen: !state.isExportPopoverOpen
      }));
    });
    (0, _defineProperty2.default)(this, "toggleIsIncludeReferencesDeepChecked", () => {
      this.setState(state => ({
        isIncludeReferencesDeepChecked: !state.isIncludeReferencesDeepChecked
      }));
    });
    (0, _defineProperty2.default)(this, "onExportClick", () => {
      const {
        onExport
      } = this.props;
      const {
        isIncludeReferencesDeepChecked
      } = this.state;
      onExport(isIncludeReferencesDeepChecked);
      this.setState({
        isExportPopoverOpen: false
      });
    });
    (0, _defineProperty2.default)(this, "getUpdatedAtColumn", () => {
      const renderUpdatedAt = dateTime => {
        if (!dateTime) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.updatedDateUnknownLabel', {
              defaultMessage: 'Last updated unknown'
            }),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 144,
              columnNumber: 11
            }
          }, /*#__PURE__*/_react.default.createElement("span", {
            tabIndex: 0,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 152,
              columnNumber: 13
            }
          }, "-"));
        }
        const updatedAt = (0, _moment.default)(dateTime);
        if (updatedAt.diff((0, _moment.default)(), 'days') > -7) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
            content: updatedAt.format('LL LT'),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 160,
              columnNumber: 11
            }
          }, /*#__PURE__*/_react.default.createElement("span", {
            tabIndex: 0,
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 161,
              columnNumber: 13
            }
          }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedRelative, {
            value: new Date(dateTime).getTime(),
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 162,
              columnNumber: 15
            }
          })));
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
          content: updatedAt.format('LL LT'),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 168,
            columnNumber: 9
          }
        }, /*#__PURE__*/_react.default.createElement("span", {
          tabIndex: 0,
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 169,
            columnNumber: 11
          }
        }, updatedAt.format('LL')));
      };
      return {
        field: 'updated_at',
        name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.lastUpdatedColumnTitle', {
          defaultMessage: 'Last updated'
        }),
        render: (field, record) => renderUpdatedAt(record.updated_at),
        sortable: true,
        width: '150px'
      };
    });
  }
  render() {
    var _this$state$activeAct, _this$state$activeAct2;
    const {
      pageIndex,
      pageSize,
      sort,
      itemId,
      items,
      totalItemCount,
      isSearching,
      filterOptions,
      selectionConfig: selection,
      capabilities,
      onDelete,
      onActionRefresh,
      selectedSavedObjects,
      onTableChange,
      goInspectObject,
      onShowRelationships,
      basePath,
      actionRegistry,
      columnRegistry,
      taggingApi,
      allowedTypes,
      deleteButtonRef
    } = this.props;
    const cappedTotalItemCount = Math.min(totalItemCount, MAX_PAGINATED_ITEM);
    const pagination = {
      pageIndex,
      pageSize,
      totalItemCount: cappedTotalItemCount,
      pageSizeOptions: [5, 10, 20, 50]
    };
    const filters = [{
      type: 'field_value_selection',
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.typeFilterName', {
        defaultMessage: 'Type'
      }),
      multiSelect: 'or',
      options: filterOptions
    }, ...(taggingApi ? [taggingApi.ui.getSearchBarFilter({
      useName: true
    })] : [])];
    const columns = [{
      field: 'type',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnTypeName', {
        defaultMessage: 'Type'
      }),
      width: '65px',
      align: 'center',
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnTypeDescription', {
        defaultMessage: 'Type of the saved object'
      }),
      sortable: true,
      'data-test-subj': 'savedObjectsTableRowType',
      render: (type, object) => {
        const typeLabel = (0, _lib.getSavedObjectLabel)(type, allowedTypes);
        return /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
          "aria-label": typeLabel,
          type: object.meta.icon || 'apps',
          size: "s",
          content: typeLabel,
          iconProps: {
            'data-test-subj': 'objectType'
          },
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 251,
            columnNumber: 13
          }
        });
      }
    }, {
      field: 'meta.title',
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnTitleName', {
        defaultMessage: 'Title'
      }),
      description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnTitleDescription', {
        defaultMessage: 'Title of the saved object'
      }),
      dataType: 'string',
      sortable: false,
      'data-test-subj': 'savedObjectsTableRowTitle',
      render: (title, object) => {
        const {
          path = ''
        } = object.meta.inAppUrl || {};
        const canGoInApp = this.props.canGoInApp(object);
        if (!canGoInApp) {
          return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
            size: "s",
            __self: this,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 277,
              columnNumber: 20
            }
          }, title || (0, _lib.getDefaultTitle)(object));
        }
        return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          href: basePath.prepend(path),
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 280,
            columnNumber: 13
          }
        }, title || (0, _lib.getDefaultTitle)(object));
      }
    }, ...(taggingApi ? [taggingApi.ui.getTableColumnDefinition({
      serverPaging: true
    })] : []), ...columnRegistry.getAll().map(column => {
      column.setColumnContext({
        capabilities
      });
      column.registerOnFinishCallback(() => {
        const {
          refreshOnFinish = () => []
        } = column;
        const objectsToRefresh = refreshOnFinish();
        onActionRefresh(objectsToRefresh);
      });
      return {
        ...column.euiColumn,
        sortable: false,
        'data-test-subj': `savedObjectsTableColumn-${column.id}`
      };
    }), this.getUpdatedAtColumn(), {
      name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnActionsName', {
        defaultMessage: 'Actions'
      }),
      width: '80px',
      actions: [{
        name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.inspectActionName', {
          defaultMessage: 'Inspect'
        }),
        description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.inspectActionDescription', {
          defaultMessage: 'Inspect this saved object'
        }),
        type: 'icon',
        icon: 'inspect',
        onClick: object => goInspectObject(object),
        'data-test-subj': 'savedObjectsTableAction-inspect'
      }, {
        name: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.viewRelationshipsActionName', {
          defaultMessage: 'Relationships'
        }),
        description: _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.columnActions.viewRelationshipsActionDescription', {
          defaultMessage: 'View the relationships this saved object has to other saved objects'
        }),
        type: 'icon',
        icon: 'kqlSelector',
        onClick: object => onShowRelationships(object),
        'data-test-subj': 'savedObjectsTableAction-relationships'
      }, ...actionRegistry.getAll().map(action => {
        action.setActionContext({
          capabilities
        });
        return {
          ...action.euiAction,
          'data-test-subj': `savedObjectsTableAction-${action.id}`,
          onClick: object => {
            this.setState({
              activeAction: action
            });
            action.registerOnFinishCallback(() => {
              this.setState({
                activeAction: undefined
              });
              const {
                refreshOnFinish = () => []
              } = action;
              const objectsToRefresh = refreshOnFinish();
              onActionRefresh(objectsToRefresh);
            });
            if (action.euiAction.onClick) {
              action.euiAction.onClick(object);
            }
          }
        };
      })]
    }];
    let queryParseError;
    if (!this.state.isSearchTextValid) {
      const parseErrorMsg = _i18n.i18n.translate('savedObjectsManagement.objectsTable.searchBar.unableToParseQueryErrorMessage', {
        defaultMessage: 'Unable to parse query'
      });
      queryParseError = /*#__PURE__*/_react.default.createElement(_eui.EuiFormErrorText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 372,
          columnNumber: 9
        }
      }, `${parseErrorMsg}. ${this.state.parseErrorMessage}`);
    }
    const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      iconType: "arrowDown",
      iconSide: "right",
      onClick: this.toggleExportPopoverVisibility,
      isDisabled: selectedSavedObjects.length === 0,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 377,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.table.exportPopoverButtonLabel",
      defaultMessage: "Export",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 383,
        columnNumber: 9
      }
    }));
    const activeActionContents = (_this$state$activeAct = (_this$state$activeAct2 = this.state.activeAction) === null || _this$state$activeAct2 === void 0 ? void 0 : _this$state$activeAct2.render()) !== null && _this$state$activeAct !== void 0 ? _this$state$activeAct : null;
    const exceededResultCount = totalItemCount > MAX_PAGINATED_ITEM;
    const anySelected = selectedSavedObjects.length > 0;
    const allHidden = anySelected && selectedSavedObjects.every(({
      meta: {
        hiddenType
      }
    }) => hiddenType);
    return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 397,
        columnNumber: 7
      }
    }, activeActionContents, /*#__PURE__*/_react.default.createElement(_eui.EuiSearchBar, {
      box: {
        'data-test-subj': 'savedObjectSearchBar',
        schema: {
          recognizedFields: ['type', 'tag']
        }
      },
      filters: filters,
      onChange: this.onChange,
      defaultQuery: this.props.initialQuery,
      toolsRight: [/*#__PURE__*/_react.default.createElement(_eui.EuiToolTip, {
        "data-test-subj": "deleteSOToolTip",
        key: "deleteSOToolTip",
        content: allHidden ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.table.deleteDisabledTooltip",
          defaultMessage: "Selected objects can\u2019t be deleted because they are hidden objects.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 415,
            columnNumber: 19
          }
        }) : undefined,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 410,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "deleteSO",
        iconType: "trash",
        color: "danger",
        onClick: onDelete,
        isDisabled: !anySelected || allHidden || !capabilities.savedObjectsManagement.delete,
        title: capabilities.savedObjectsManagement.delete ? undefined : _i18n.i18n.translate('savedObjectsManagement.objectsTable.table.deleteButtonTitle', {
          defaultMessage: 'Unable to delete saved objects'
        }),
        "data-test-subj": "savedObjectsManagementDelete",
        buttonRef: deleteButtonRef,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 422,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.table.deleteButtonLabel",
        defaultMessage: "Delete",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 443,
          columnNumber: 17
        }
      }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
        key: "exportSOOptions",
        button: button,
        isOpen: this.state.isExportPopoverOpen,
        closePopover: this.closeExportPopover,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 449,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.exportOptionsLabel",
          defaultMessage: "Options",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 457,
            columnNumber: 19
          }
        }),
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 455,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
        name: "includeReferencesDeep",
        label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "savedObjectsManagement.objectsTable.exportObjectsConfirmModal.includeReferencesDeepLabel",
          defaultMessage: "Include related objects",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 466,
            columnNumber: 21
          }
        }),
        checked: this.state.isIncludeReferencesDeepChecked,
        onChange: this.toggleIsIncludeReferencesDeepChecked,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 463,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 475,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
        key: "exportSO",
        iconType: "exportAction",
        onClick: this.onExportClick,
        fill: true,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 476,
          columnNumber: 17
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "savedObjectsManagement.objectsTable.table.exportButtonLabel",
        defaultMessage: "Export",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 477,
          columnNumber: 19
        }
      }))))],
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 399,
        columnNumber: 9
      }
    }), queryParseError, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 487,
        columnNumber: 9
      }
    }), exceededResultCount && /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "s",
      "data-test-subj": "savedObjectsTableTooManyResultsLabel",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 490,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "savedObjectsManagement.objectsTable.table.tooManyResultsLabel",
      defaultMessage: "Showing {limit} of {totalItemCount, plural, one {# object} other {# objects}}",
      values: {
        totalItemCount,
        limit: MAX_PAGINATED_ITEM
      },
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 491,
        columnNumber: 15
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "s",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 497,
        columnNumber: 13
      }
    })), /*#__PURE__*/_react.default.createElement("div", {
      "data-test-subj": "savedObjectsTable",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 500,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiBasicTable, {
      loading: isSearching,
      itemId: itemId,
      items: items,
      columns: columns,
      pagination: pagination,
      sorting: {
        sort
      },
      selection: selection,
      onChange: onTableChange,
      rowProps: item => ({
        'data-test-subj': `savedObjectsTableRow row-${item.id}`
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 501,
        columnNumber: 11
      }
    })));
  }
}
exports.Table = Table;