"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.importFile = importFile;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

async function importFile(http, file, {
  createNewCopies,
  overwrite
}) {
  const formData = new FormData();
  formData.append('file', file);
  const query = createNewCopies ? {
    createNewCopies
  } : {
    overwrite
  };
  return await http.post('/api/saved_objects/_import', {
    body: formData,
    headers: {
      // Important to be undefined, it forces proper headers to be set for FormData
      'Content-Type': undefined
    },
    query
  });
}