"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConfirmDeleteModal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/components/job_action_menu/confirm_delete_modal/confirm_delete_modal.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class ConfirmDeleteModal extends _react.Component {
  renderJobs() {
    const {
      jobs
    } = this.props;
    const jobItems = jobs.map(({
      id,
      status
    }) => {
      const startedMessage = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.startedMessage', {
        defaultMessage: 'started'
      });
      const statusText = status === 'started' ? ` (${startedMessage})` : null;
      return /*#__PURE__*/_react.default.createElement("li", {
        key: id,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 34,
          columnNumber: 9
        }
      }, id, statusText);
    });
    return /*#__PURE__*/_react.default.createElement("ul", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 41,
        columnNumber: 12
      }
    }, jobItems);
  }
  render() {
    const {
      isSingleSelection,
      jobs,
      onCancel,
      onConfirm
    } = this.props;
    const confirmModalTitleId = (0, _eui.htmlIdGenerator)()('confirmModalTitle');
    let title;
    let content;
    if (isSingleSelection) {
      const {
        id,
        status
      } = jobs[0];
      title = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.deleteSingleJobTitle', {
        defaultMessage: "Delete rollup job ''{id}''?",
        values: {
          id
        }
      });
      if (status === 'started') {
        content = /*#__PURE__*/_react.default.createElement("p", {
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 64,
            columnNumber: 11
          }
        }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
          id: "xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.deleteSingleJobDescription",
          defaultMessage: "This job has been started.",
          __self: this,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 65,
            columnNumber: 13
          }
        }));
      }
    } else {
      title = _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.multipleDeletionTitle', {
        defaultMessage: 'Delete {count} rollup jobs?',
        values: {
          count: jobs.length
        }
      });
      content = /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 82,
          columnNumber: 9
        }
      }, /*#__PURE__*/_react.default.createElement("p", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 83,
          columnNumber: 11
        }
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.multipleDeletionDescription",
        defaultMessage: "You are about to delete {isSingleSelection, plural, one {this job} other {these jobs}}",
        values: {
          isSingleSelection: isSingleSelection ? 1 : 0
        },
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 84,
          columnNumber: 13
        }
      })), this.renderJobs());
    }
    return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
      "aria-labelledby": confirmModalTitleId,
      title: title,
      titleProps: {
        id: confirmModalTitleId
      },
      onCancel: onCancel,
      onConfirm: onConfirm,
      cancelButtonText: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.cancelButtonText', {
        defaultMessage: 'Cancel'
      }),
      buttonColor: "danger",
      confirmButtonText: _i18n.i18n.translate('xpack.rollupJobs.jobActionMenu.deleteJob.confirmModal.confirmButtonText', {
        defaultMessage: 'Delete'
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 7
      }
    }, content);
  }
}
exports.ConfirmDeleteModal = ConfirmDeleteModal;
(0, _defineProperty2.default)(ConfirmDeleteModal, "propTypes", {
  isSingleSelection: _propTypes.default.bool.isRequired,
  jobs: _propTypes.default.array.isRequired,
  onCancel: _propTypes.default.func.isRequired,
  onConfirm: _propTypes.default.func.isRequired
});