"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ScheduledReportAuditAction = void 0;
exports.scheduledReportAuditEvent = scheduledReportAuditEvent;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let ScheduledReportAuditAction = exports.ScheduledReportAuditAction = /*#__PURE__*/function (ScheduledReportAuditAction) {
  ScheduledReportAuditAction["SCHEDULE"] = "scheduled_report_schedule";
  ScheduledReportAuditAction["LIST"] = "scheduled_report_list";
  ScheduledReportAuditAction["DISABLE"] = "scheduled_report_disable";
  ScheduledReportAuditAction["DELETE"] = "scheduled_report_delete";
  ScheduledReportAuditAction["UPDATE"] = "scheduled_report_update";
  ScheduledReportAuditAction["ENABLE"] = "scheduled_report_enable";
  return ScheduledReportAuditAction;
}({});
const scheduledReportEventVerbs = {
  scheduled_report_schedule: ['create', 'creating', 'created'],
  scheduled_report_list: ['access', 'accessing', 'accessed'],
  scheduled_report_disable: ['disable', 'disabling', 'disabled'],
  scheduled_report_delete: ['delete', 'deleting', 'deleted'],
  scheduled_report_update: ['update', 'updating', 'updated'],
  scheduled_report_enable: ['enable', 'enabling', 'enabled']
};
const scheduledReportEventTypes = {
  scheduled_report_schedule: 'creation',
  scheduled_report_list: 'access',
  scheduled_report_disable: 'change',
  scheduled_report_delete: 'deletion',
  scheduled_report_update: 'update',
  scheduled_report_enable: 'change'
};
function scheduledReportAuditEvent({
  action,
  savedObject,
  outcome,
  error
}) {
  const doc = savedObject ? [`scheduled report [id=${savedObject.id}]`, savedObject.name && `[name=${savedObject.name}]`].filter(Boolean).join(' ') : 'a scheduled report';
  const [present, progressive, past] = scheduledReportEventVerbs[action];
  const message = error ? `Failed attempt to ${present} ${doc}` : outcome === 'unknown' ? `User is ${progressive} ${doc}` : `User has ${past} ${doc}`;
  const type = scheduledReportEventTypes[action];
  return {
    message,
    event: {
      action,
      category: ['database'],
      type: type ? [type] : undefined,
      outcome: outcome !== null && outcome !== void 0 ? outcome : error ? 'failure' : 'success'
    },
    kibana: {
      saved_object: savedObject
    },
    error: error && {
      code: error.name,
      message: error.message
    }
  };
}