"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  rawNotificationSchema: true,
  rawScheduledReportSchema: true
};
exports.rawScheduledReportSchema = exports.rawNotificationSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _v = require("./v3");
Object.keys(_v).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _v[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _v[key];
    }
  });
});
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const rawNotificationSchema = exports.rawNotificationSchema = _v.rawNotificationSchema.extends({
  email: _configSchema.schema.maybe(
  // This is now nullable to allow removing the email notification altogether
  _configSchema.schema.nullable(_v.rawEmailNotificationSchema.extends({
    subject: _configSchema.schema.maybe(_configSchema.schema.string({
      maxLength: 1000
    })),
    message: _configSchema.schema.maybe(_configSchema.schema.string({
      maxLength: 10000
    }))
  })))
});
const rawScheduledReportSchema = exports.rawScheduledReportSchema = _v.rawScheduledReportSchema.extends({
  notification: _configSchema.schema.maybe(rawNotificationSchema)
});