"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AGENT_STATUS_COLORS = exports.AGENT_GROUP_KEY = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let AGENT_GROUP_KEY = exports.AGENT_GROUP_KEY = /*#__PURE__*/function (AGENT_GROUP_KEY) {
  AGENT_GROUP_KEY[AGENT_GROUP_KEY["All"] = 0] = "All";
  AGENT_GROUP_KEY[AGENT_GROUP_KEY["Platform"] = 1] = "Platform";
  AGENT_GROUP_KEY[AGENT_GROUP_KEY["Policy"] = 2] = "Policy";
  AGENT_GROUP_KEY[AGENT_GROUP_KEY["Agent"] = 3] = "Agent";
  return AGENT_GROUP_KEY;
}({});
/**
 * Agent status color constants for UI display
 * Maps agent availability states to EUI color types
 */
const AGENT_STATUS_COLORS = exports.AGENT_STATUS_COLORS = {
  ONLINE: 'success',
  DEGRADED: 'warning',
  UNAVAILABLE: 'danger'
};