"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolResultStoreMock = exports.createScopedRunnerDepsMock = exports.createRunnerDepsMock = exports.createAttachmentsServiceMock = void 0;
var _loggingMocks = require("@kbn/logging-mocks");
var _mocks = require("@kbn/core/server/mocks");
var _mocks2 = require("@kbn/spaces-plugin/server/mocks");
var _model_provider = require("./model_provider");
var _tools = require("./tools");
var _agents = require("./agents");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createToolResultStoreMock = () => {
  return {
    has: jest.fn(),
    get: jest.fn(),
    add: jest.fn(),
    delete: jest.fn(),
    asReadonly: jest.fn()
  };
};
exports.createToolResultStoreMock = createToolResultStoreMock;
const createAttachmentsServiceMock = () => {
  return {
    validate: jest.fn(),
    getTypeDefinition: jest.fn()
  };
};
exports.createAttachmentsServiceMock = createAttachmentsServiceMock;
const createScopedRunnerDepsMock = () => {
  return {
    elasticsearch: _mocks.elasticsearchServiceMock.createStart(),
    security: _mocks.securityServiceMock.createStart(),
    spaces: _mocks2.spacesMock.createStart(),
    modelProvider: (0, _model_provider.createModelProviderMock)(),
    toolsService: (0, _tools.createToolsServiceStartMock)(),
    agentsService: (0, _agents.createAgentsServiceStartMock)(),
    logger: _loggingMocks.loggerMock.create(),
    request: _mocks.httpServerMock.createKibanaRequest(),
    resultStore: createToolResultStoreMock(),
    attachmentsService: createAttachmentsServiceMock()
  };
};
exports.createScopedRunnerDepsMock = createScopedRunnerDepsMock;
const createRunnerDepsMock = () => {
  return {
    elasticsearch: _mocks.elasticsearchServiceMock.createStart(),
    security: _mocks.securityServiceMock.createStart(),
    spaces: _mocks2.spacesMock.createStart(),
    modelProviderFactory: (0, _model_provider.createModelProviderFactoryMock)(),
    toolsService: (0, _tools.createToolsServiceStartMock)(),
    agentsService: (0, _agents.createAgentsServiceStartMock)(),
    logger: _loggingMocks.loggerMock.create(),
    attachmentsService: createAttachmentsServiceMock()
  };
};
exports.createRunnerDepsMock = createRunnerDepsMock;