"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createToolProvider = void 0;
var _tool_conversion = require("../../tools/utils/tool_conversion");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createToolProvider = ({
  registry,
  runner,
  request
}) => {
  return {
    has: async ({
      toolId
    }) => {
      return registry.has(toolId);
    },
    get: async ({
      toolId
    }) => {
      const tool = await registry.get(toolId);
      return (0, _tool_conversion.toExecutableTool)({
        tool,
        runner,
        request
      });
    },
    list: async () => {
      const tools = await registry.list();
      return tools.map(tool => (0, _tool_conversion.toExecutableTool)({
        tool,
        runner,
        request
      }));
    }
  };
};
exports.createToolProvider = createToolProvider;