"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.resolveSelectedConnectorId = void 0;
var _inferenceCommon = require("@kbn/inference-common");
var _managementSettingsIds = require("@kbn/management-settings-ids");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// TODO: Import from gen-ai-settings-plugin (package) once available
const NO_DEFAULT_CONNECTOR = 'NO_DEFAULT_CONNECTOR';
const selectDefaultConnector = ({
  connectors
}) => {
  const inferenceConnector = connectors.find(connector => connector.type === _inferenceCommon.InferenceConnectorType.Inference);
  if (inferenceConnector) return inferenceConnector;
  const openAIConnector = connectors.find(connector => connector.type === _inferenceCommon.InferenceConnectorType.OpenAI);
  if (openAIConnector) return openAIConnector;
  return connectors[0];
};
const tryGetInferenceDefault = async (inference, request) => {
  try {
    const defaultConnector = await inference.getDefaultConnector(request);
    return defaultConnector.connectorId;
  } catch {
    return undefined;
  }
};
const tryGetFallbackConnector = async (inference, request) => {
  try {
    const connectors = await inference.getConnectorList(request);
    if (connectors.length > 0) {
      const fallbackConnector = selectDefaultConnector({
        connectors
      });
      return fallbackConnector.connectorId;
    }
  } catch {
    // Ignore errors
  }
  return undefined;
};
const resolveSelectedConnectorId = async ({
  uiSettings,
  savedObjects,
  request,
  connectorId,
  inference
}) => {
  const soClient = savedObjects.getScopedClient(request);
  const uiSettingsClient = uiSettings.asScopedToClient(soClient);
  const [defaultConnectorSetting, defaultConnectorOnly] = await Promise.all([uiSettingsClient.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR), uiSettingsClient.get(_managementSettingsIds.GEN_AI_SETTINGS_DEFAULT_AI_CONNECTOR_DEFAULT_ONLY)]);
  const hasValidDefaultConnector = defaultConnectorSetting && defaultConnectorSetting !== NO_DEFAULT_CONNECTOR;
  if (defaultConnectorOnly && hasValidDefaultConnector) {
    if (connectorId && connectorId !== defaultConnectorSetting) {
      throw new Error(`Connector ID [${connectorId}] does not match the configured default connector ID [${defaultConnectorSetting}].`);
    }
    return defaultConnectorSetting;
  }
  if (connectorId) return connectorId;
  if (hasValidDefaultConnector) return defaultConnectorSetting;
  return (await tryGetInferenceDefault(inference, request)) || (await tryGetFallbackConnector(inference, request));
};
exports.resolveSelectedConnectorId = resolveSelectedConnectorId;