"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createAttachmentTypeRegistry = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createAttachmentTypeRegistry = () => {
  return new AttachmentTypeRegistryImpl();
};
exports.createAttachmentTypeRegistry = createAttachmentTypeRegistry;
class AttachmentTypeRegistryImpl {
  constructor() {
    (0, _defineProperty2.default)(this, "attachmentTypes", new Map());
  }
  register(type) {
    if (this.attachmentTypes.has(type.id)) {
      throw new Error(`Attachment type with id ${type.id} already registered`);
    }
    this.attachmentTypes.set(type.id, type);
  }
  has(toolId) {
    return this.attachmentTypes.has(toolId);
  }
  get(toolId) {
    return this.attachmentTypes.get(toolId);
  }
  list() {
    return [...this.attachmentTypes.values()];
  }
}