"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.selectTools = void 0;
var _onechatCommon = require("@kbn/onechat-common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const selectTools = async ({
  conversation,
  request,
  toolProvider,
  agentConfiguration,
  attachmentsService
}) => {
  // create tool selection for attachments types
  const attachmentTypes = conversation.attachmentTypes.map(type => type.type);
  const attachmentToolIds = getToolsForAttachmentTypes(attachmentTypes, attachmentsService);
  const attachmentToolSelection = {
    tool_ids: attachmentToolIds
  };

  // convert attachment-bound tools
  const attachmentBoundTools = conversation.attachments.flatMap(attachment => attachment.tools).map(tool => attachmentsService.convertAttachmentTool(tool));

  // pick tools from provider (from agent config and attachment-type tools)
  const registryTools = await pickTools({
    selection: [attachmentToolSelection, ...agentConfiguration.tools],
    toolProvider,
    request
  });
  return [...attachmentBoundTools, ...registryTools];
};
exports.selectTools = selectTools;
const getToolsForAttachmentTypes = (attachmentTypes, attachmentsService) => {
  const tools = new Set();
  for (const type of attachmentTypes) {
    const definition = attachmentsService.getTypeDefinition(type);
    if (definition && definition.getTools) {
      const definitionTools = definition.getTools();
      definitionTools.forEach(toolId => tools.add(toolId));
    }
  }
  return [...tools];
};
const pickTools = async ({
  toolProvider,
  selection,
  request
}) => {
  const tools = await toolProvider.list({
    request
  });
  return (0, _onechatCommon.filterToolsBySelection)(tools, selection);
};