"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.processToolNodeResponse = exports.processStructuredAnswerResponse = exports.processResearchResponse = exports.processAnswerResponse = void 0;
var _messages = require("@langchain/core/messages");
var _langchain = require("@kbn/onechat-genai-utils/langchain");
var _errors = require("@kbn/onechat-common/base/errors");
var _agents = require("@kbn/onechat-common/agents");
var _actions = require("./actions");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const processResearchResponse = message => {
  var _message$tool_calls;
  if ((_message$tool_calls = message.tool_calls) !== null && _message$tool_calls !== void 0 && _message$tool_calls.length) {
    return (0, _actions.toolCallAction)((0, _langchain.extractToolCalls)(message));
  } else {
    const textContent = (0, _langchain.extractTextContent)(message);
    if (textContent) {
      return (0, _actions.handoverAction)(textContent);
    } else {
      return (0, _actions.errorAction)((0, _errors.createAgentExecutionError)('agent returned an empty response', _agents.AgentExecutionErrorCode.emptyResponse, {}));
    }
  }
};

/**
 * Create execute tool action based on the tool node result.
 */
exports.processResearchResponse = processResearchResponse;
const processToolNodeResponse = toolNodeResult => {
  const toolMessages = toolNodeResult.filter(_messages.isToolMessage);
  return (0, _actions.executeToolAction)(toolMessages.map(msg => {
    return {
      toolCallId: msg.tool_call_id,
      content: (0, _langchain.extractTextContent)(msg),
      artifact: msg.artifact
    };
  }));
};
exports.processToolNodeResponse = processToolNodeResponse;
const processAnswerResponse = message => {
  const textContent = (0, _langchain.extractTextContent)(message);
  if (textContent) {
    return (0, _actions.answerAction)((0, _langchain.extractTextContent)(message));
  } else {
    return (0, _actions.errorAction)((0, _errors.createAgentExecutionError)('agent returned an empty response', _agents.AgentExecutionErrorCode.emptyResponse, {}));
  }
};
exports.processAnswerResponse = processAnswerResponse;
const processStructuredAnswerResponse = response => {
  try {
    if (response && typeof response === 'object') {
      const action = (0, _actions.structuredAnswerAction)(response);
      return action;
    } else if (typeof response === 'string') {
      return (0, _actions.answerAction)(response);
    } else {
      return (0, _actions.errorAction)((0, _errors.createAgentExecutionError)('agent returned an invalid structured response', _agents.AgentExecutionErrorCode.emptyResponse, {}));
    }
  } catch (error) {
    return (0, _actions.errorAction)((0, _errors.createAgentExecutionError)(`Error processing structured response: ${error instanceof Error ? error.message : String(error)}`, _agents.AgentExecutionErrorCode.emptyResponse, {}));
  }
};
exports.processStructuredAnswerResponse = processStructuredAnswerResponse;