"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useToolsTableSearch = void 0;
var _eui = require("@elastic/eui");
var _lodash = require("lodash");
var _react = _interopRequireWildcard(require("react"));
var _use_tool_tags = require("../../../hooks/tools/use_tool_tags");
var _use_tools = require("../../../hooks/tools/use_tools");
var _use_query_state = require("../../../hooks/use_query_state");
var _i18n = require("../../../utils/i18n");
var _filter_option_with_matches_badge = require("../../common/filter_option_with_matches_badge");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/table/tools_table_search.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const toValidSearchQuery = query => {
  try {
    const queryString = query !== null && query !== void 0 ? query : '';
    _eui.EuiSearchBar.Query.parse(queryString);
    return queryString;
  } catch (error) {
    return '';
  }
};
const getToolsTableSearchConfig = ({
  matchesByTag,
  tags
}) => ({
  box: {
    incremental: true,
    placeholder: _i18n.labels.tools.searchToolsPlaceholder
  },
  filters: [{
    type: 'field_value_selection',
    field: 'tags',
    name: _i18n.labels.tools.tagsFilter,
    multiSelect: 'or',
    options: tags.map(tag => {
      var _matchesByTag$tag;
      return {
        value: tag,
        name: tag,
        view: /*#__PURE__*/_react.default.createElement(_filter_option_with_matches_badge.FilterOptionWithMatchesBadge, {
          name: tag,
          matches: (_matchesByTag$tag = matchesByTag[tag]) !== null && _matchesByTag$tag !== void 0 ? _matchesByTag$tag : 0,
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 49,
            columnNumber: 15
          }
        })
      };
    }),
    autoSortOptions: false,
    searchThreshold: 1
  }]
});
const useToolsTableSearch = () => {
  const {
    tools
  } = (0, _use_tools.useToolsService)();
  const {
    tags
  } = (0, _use_tool_tags.useToolsTags)();
  const [results, setResults] = (0, _react.useState)(tools);
  const [searchQuery, setSearchQuery] = (0, _use_query_state.useQueryState)('search', {
    defaultValue: '',
    parse: toValidSearchQuery
  });
  (0, _react.useEffect)(() => {
    setResults(tools);
  }, [tools]);
  const handleChange = (0, _react.useCallback)(({
    query,
    queryText,
    error: searchError
  }) => {
    if (searchError) {
      return;
    }
    const newItems = query ? _eui.EuiSearchBar.Query.execute(query, tools, {
      defaultFields: ['id', 'description', 'type']
    }) : tools;
    setSearchQuery(queryText);
    setResults(newItems);
  }, [tools, setSearchQuery]);
  const matchesByTag = (0, _react.useMemo)(() => {
    return (0, _lodash.countBy)(tools.flatMap(tool => tool.tags));
  }, [tools]);
  const searchConfig = (0, _react.useMemo)(() => ({
    ...getToolsTableSearchConfig({
      matchesByTag,
      tags
    }),
    onChange: handleChange,
    query: searchQuery
  }), [handleChange, matchesByTag, tags, searchQuery]);
  return {
    searchConfig,
    results
  };
};
exports.useToolsTableSearch = useToolsTableSearch;