"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createWorkflowFormValidationSchema = void 0;
var _i18n = require("@kbn/i18n");
var _tools = require("@kbn/onechat-common/tools");
var _zod = require("@kbn/zod");
var _shared_tool_validation = require("./shared_tool_validation");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const workflowI18nMessages = {
  workflowId: {
    requiredError: _i18n.i18n.translate('xpack.onechat.tools.workflow.workflowId.requiredError', {
      defaultMessage: 'Workflow is required.'
    }),
    notFoundError: _i18n.i18n.translate('xpack.onechat.tools.workflow.workflowId.notFoundError', {
      defaultMessage: 'Selected workflow not found.'
    }),
    apiError: _i18n.i18n.translate('xpack.onechat.tools.workflow.workflowId.error', {
      defaultMessage: 'Error loading workflows.'
    })
  }
};
const createWorkflowFormValidationSchema = toolsService => _zod.z.object({
  toolId: _shared_tool_validation.sharedValidationSchemas.toolId,
  description: _shared_tool_validation.sharedValidationSchemas.description,
  labels: _shared_tool_validation.sharedValidationSchemas.labels,
  workflow_id: _zod.z.string().min(1, {
    message: workflowI18nMessages.workflowId.requiredError
  }).refine(async workflowId => {
    if (!workflowId || !workflowId.trim()) {
      return true;
    }
    try {
      const workflow = await toolsService.getWorkflow(workflowId);
      return workflow.id === workflowId;
    } catch {
      return false;
    }
  }, {
    message: workflowI18nMessages.workflowId.notFoundError
  }),
  wait_for_completion: _zod.z.boolean(),
  type: _zod.z.literal(_tools.ToolType.workflow)
});
exports.createWorkflowFormValidationSchema = createWorkflowFormValidationSchema;