"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SystemReferences = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_tool_type_info = require("../../../../hooks/tools/use_tool_type_info");
var _tool_form_section = require("../components/tool_form_section");
var _i18n = require("../i18n");
var _tool_form = require("../tool_form");
var _tools_form_registry = require("../registry/tools_form_registry");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/sections/system_references.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const SystemReferences = ({
  mode,
  toolType,
  setToolType
}) => {
  var _errors$type, _errors$toolId, _errors$description;
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    control,
    formState: {
      errors
    }
  } = (0, _reactHookForm.useFormContext)();
  const type = (0, _reactHookForm.useWatch)({
    control,
    name: 'type'
  });
  (0, _react2.useEffect)(() => {
    if (type && type !== toolType && setToolType) {
      setToolType(type);
    }
  }, [type, toolType, setToolType]);
  const descriptionRef = (0, _react2.useRef)(null);
  const isReadOnly = mode === _tool_form.ToolFormMode.View;
  const isToolIdDisabled = mode === _tool_form.ToolFormMode.Edit || isReadOnly;
  const {
    toolTypes: serverToolTypes,
    isLoading: toolTypesLoading
  } = (0, _use_tool_type_info.useToolTypes)();
  const editableToolTypes = (0, _react2.useMemo)(() => {
    let editableTypes = (0, _tools_form_registry.getEditableToolTypes)();
    if (!toolTypesLoading && serverToolTypes) {
      const serverEnabledEditableTypes = serverToolTypes.filter(st => st.create).map(st => st.type);
      editableTypes = editableTypes.filter(t => serverEnabledEditableTypes.includes(t.value));
    }
    return editableTypes;
  }, [serverToolTypes, toolTypesLoading]);
  return /*#__PURE__*/_react2.default.createElement(_tool_form_section.ToolFormSection, {
    title: _i18n.i18nMessages.systemReferences.documentation.title,
    icon: "bullseye",
    description: _i18n.i18nMessages.systemReferences.documentation.description,
    content: /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      css: (0, _react.css)`
            background-color: ${euiTheme.colors.backgroundBaseSubdued};
            padding: ${euiTheme.size.base};
          `,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 76,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      color: euiTheme.colors.textHeading,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 83,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement("h4", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 84,
        columnNumber: 13
      }
    }, _i18n.i18nMessages.systemReferences.documentation.fieldsHelp.title)), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 86,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 87,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 15
      }
    }, _i18n.i18nMessages.systemReferences.documentation.fieldsHelp.toolId.label), /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 90,
        columnNumber: 17
      }
    }, _i18n.i18nMessages.systemReferences.documentation.fieldsHelp.toolId.description)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
      grow: 0,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 96,
        columnNumber: 11
      }
    }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
      size: "s",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 97,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react2.default.createElement("strong", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 98,
        columnNumber: 15
      }
    }, _i18n.i18nMessages.systemReferences.documentation.fieldsHelp.description.label), /*#__PURE__*/_react2.default.createElement(_eui.EuiTextColor, {
      color: "subdued",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 101,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react2.default.createElement("div", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 102,
        columnNumber: 17
      }
    }, _i18n.i18nMessages.systemReferences.documentation.fieldsHelp.description.description))))),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 71,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18nMessages.configuration.form.type.label,
    error: (_errors$type = errors.type) === null || _errors$type === void 0 ? void 0 : _errors$type.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 111,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "type",
    render: ({
      field: {
        ref,
        ...field
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiSelect, (0, _extends2.default)({
      "data-test-subj": "agentBuilderToolTypeSelect",
      options: editableToolTypes
    }, field, {
      inputRef: ref,
      disabled: isToolIdDisabled,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 116,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "agentBuilderToolIdRow",
    isDisabled: isToolIdDisabled,
    label: _i18n.i18nMessages.systemReferences.form.toolId.label,
    isInvalid: !!errors.toolId,
    helpText: _i18n.i18nMessages.systemReferences.form.toolId.helpText,
    error: (_errors$toolId = errors.toolId) === null || _errors$toolId === void 0 ? void 0 : _errors$toolId.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 126,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "toolId",
    render: ({
      field: {
        ref,
        ...field
      },
      fieldState: {
        invalid
      }
    }) => /*#__PURE__*/_react2.default.createElement(_eui.EuiFieldText, (0, _extends2.default)({
      "data-test-subj": "agentBuilderToolIdInput",
      disabled: isToolIdDisabled,
      placeholder: "namespace.tool_name (e.g., acme.financial.search)",
      readOnly: isReadOnly
    }, field, {
      inputRef: ref,
      isInvalid: invalid,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 138,
        columnNumber: 13
      }
    })),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react2.default.createElement(_eui.EuiFormRow, {
    "data-test-subj": "agentBuilderToolDescriptionRow",
    label: _i18n.i18nMessages.systemReferences.form.description.label,
    isInvalid: !!errors.description,
    error: (_errors$description = errors.description) === null || _errors$description === void 0 ? void 0 : _errors$description.message,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactHookForm.Controller, {
    control: control,
    name: "description",
    render: ({
      field: {
        ref,
        ...field
      }
    }) => {
      var _descriptionRef$curre;
      ref((_descriptionRef$curre = descriptionRef.current) === null || _descriptionRef$curre === void 0 ? void 0 : _descriptionRef$curre.textarea);
      return /*#__PURE__*/_react2.default.createElement(_eui.EuiMarkdownEditor, (0, _extends2.default)({
        "data-test-subj": "agentBuilderToolDescriptionEditor",
        "aria-label": _i18n.i18nMessages.systemReferences.form.description.label,
        readOnly: isReadOnly,
        ref: descriptionRef
      }, field, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 162,
          columnNumber: 15
        }
      }));
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 9
    }
  })));
};
exports.SystemReferences = SystemReferences;