"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolEditContextMenu = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactHookForm = require("react-hook-form");
var _use_navigation = require("../../../../hooks/use_navigation");
var _tools_provider = require("../../../../context/tools_provider");
var _i18n = require("../../../../utils/i18n");
var _app_paths = require("../../../../utils/app_paths");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/form/components/tool_edit_context_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const ToolEditContextMenu = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    navigateToOnechatUrl
  } = (0, _use_navigation.useNavigation)();
  const {
    cloneTool,
    deleteTool
  } = (0, _tools_provider.useToolsActions)();
  const {
    control
  } = (0, _reactHookForm.useFormContext)();
  const toolId = (0, _reactHookForm.useWatch)({
    name: 'toolId',
    control
  });
  const [isOpen, setIsOpen] = (0, _react2.useState)(false);
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPopover, {
    panelPaddingSize: "xs",
    isOpen: isOpen,
    closePopover: () => setIsOpen(false),
    zIndex: Number(euiTheme.levels.header) - 1,
    button: /*#__PURE__*/_react2.default.createElement(_eui.EuiButtonIcon, {
      "data-test-subj": "agentBuilderToolContextMenuButton",
      size: "m",
      iconType: "boxesVertical",
      onClick: () => setIsOpen(openState => !openState),
      "aria-label": _i18n.labels.tools.editToolContextMenuButtonLabel,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 38,
        columnNumber: 9
      }
    }),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 32,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuPanel, {
    size: "s",
    items: [/*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "agentBuilderToolCloneButton",
      key: "clone",
      icon: "copy",
      size: "s",
      onClick: () => {
        cloneTool(toolId);
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 50,
        columnNumber: 11
      }
    }, _i18n.labels.tools.cloneToolButtonLabel), /*#__PURE__*/_react2.default.createElement(_eui.EuiContextMenuItem, {
      "data-test-subj": "agentBuilderToolDeleteButton",
      key: "delete",
      icon: "trash",
      size: "s",
      css: (0, _react.css)`
              color: ${euiTheme.colors.textDanger};
            `,
      onClick: () => {
        setIsOpen(false);
        deleteTool(toolId, {
          onConfirm: () => navigateToOnechatUrl(_app_paths.appPaths.tools.list)
        });
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 61,
        columnNumber: 11
      }
    }, _i18n.labels.tools.deleteToolButtonLabel)],
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 7
    }
  }));
};
exports.ToolEditContextMenu = ToolEditContextMenu;