"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useLensInput = useLensInput;
var _react = require("react");
var _uuid = require("uuid");
var _config_builder = require("@kbn/lens-embeddable-utils/config_builder");
var _useAsync = _interopRequireDefault(require("react-use/lib/useAsync"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useLensInput({
  dataViews,
  lens,
  lensConfig
}) {
  const lensHelpersAsync = (0, _useAsync.default)(() => {
    return lens.stateHelperApi();
  }, [lens]);

  // convert lens config to lens attributes
  const lensAttributes = (0, _react.useMemo)(() => {
    return new _config_builder.LensConfigBuilder().fromAPIFormat(lensConfig);
  }, [lensConfig]);
  const [lensInput, setLensInput] = (0, _react.useState)({
    attributes: lensAttributes,
    id: (0, _uuid.v4)()
  });
  const isLoading = !lensHelpersAsync.value || !lensInput;
  return {
    lensInput,
    setLensInput,
    isLoading,
    error: lensHelpersAsync.error || undefined
  };
}