"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.VisualizationActions = VisualizationActions;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _edit_visualization_button = require("./edit_visualization_button");
var _styles = require("./styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/tools/esql/shared/visualization_actions.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function VisualizationActions({
  onSave,
  uiActions,
  lensInput,
  lensLoadEvent,
  setLensInput
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!lensInput) {
    return null;
  }
  const containerCss = (0, _css.css)((0, _styles.actionsContainer)(euiTheme));
  const iconCss = (0, _css.css)({
    marginLeft: '-1px'
  });
  return /*#__PURE__*/_react.default.createElement("div", {
    className: `visualization-button-actions ${containerCss}`,
    "data-test-subj": "visualizationButtonActions",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 44,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_edit_visualization_button.EditVisualizationButton, {
    uiActions: uiActions,
    lensInput: lensInput,
    lensLoadEvent: lensLoadEvent,
    onAttributesChange: attrs => setLensInput({
      ...lensInput,
      attributes: attrs
    }),
    onApply: onSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    display: "base",
    color: "text",
    size: "s",
    iconType: "save",
    "aria-label": _edit_visualization_button.saveButtonLabel,
    className: iconCss,
    onClick: onSave,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }));
}