"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundThinkingPanel = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _round_flyout = require("./round_flyout");
var _round_steps = require("./steps/round_steps");
var _thinking_time_display = require("./thinking_time_display");
var _conversation = require("../../conversation.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_thinking/round_thinking_panel.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const rawResponseButtonLabel = _i18n.i18n.translate('xpack.onechat.conversation.rawResponseButton', {
  defaultMessage: 'View JSON'
});
const closePanelLabel = _i18n.i18n.translate('xpack.onechat.conversation.closePanel', {
  defaultMessage: 'Close panel'
});
const reasoningLabel = _i18n.i18n.translate('xpack.onechat.conversation.reasoning', {
  defaultMessage: 'Reasoning'
});
const completedReasoningLabel = _i18n.i18n.translate('xpack.onechat.conversation.completedReasoning', {
  defaultMessage: 'Completed reasoning'
});
const RoundThinkingPanel = ({
  steps,
  isLoading,
  rawRound,
  onClose
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const [showFlyout, setShowFlyout] = (0, _react.useState)(false);
  const containerStyles = (0, _react2.css)`
    background-color: ${euiTheme.colors.backgroundBasePlain};
    ${_conversation.roundedBorderRadiusStyles}
    border: 1px solid ${euiTheme.colors.borderStrongPrimary};
    padding: ${euiTheme.size.base};
    ${(0, _eui.useEuiShadow)('l')};
  `;
  const toggleFlyout = () => {
    setShowFlyout(!showFlyout);
  };
  const displayTitle = isLoading ? reasoningLabel : completedReasoningLabel;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    responsive: false,
    css: containerStyles,
    "data-test-subj": "agentBuilderThinkingPanel",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 74,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 82,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "xs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 83,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 84,
      columnNumber: 15
    }
  }, displayTitle))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 87,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "agentBuilderThinkingToggle",
    "aria-label": closePanelLabel,
    iconType: "cross",
    color: "text",
    onClick: onClose,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 88,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_round_steps.RoundSteps, {
    steps: steps,
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 9
    }
  }), !isLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "column",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 102,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiHorizontalRule, {
    margin: "none",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 103,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "spaceBetween",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_thinking_time_display.ThinkingTimeDisplay, {
    timeToFirstToken: rawRound.time_to_first_token,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 17
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: 'code',
    color: "text",
    iconSide: "left",
    onClick: toggleFlyout,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 109,
      columnNumber: 17
    }
  }, rawResponseButtonLabel))))), /*#__PURE__*/_react.default.createElement(_round_flyout.RoundFlyout, {
    isOpen: showFlyout,
    onClose: toggleFlyout,
    rawRound: rawRound,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 117,
      columnNumber: 7
    }
  }));
};
exports.RoundThinkingPanel = RoundThinkingPanel;