"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Cursor = void 0;
exports.createVisualizationRenderer = createVisualizationRenderer;
exports.visualizationTagParser = exports.loadingCursorPlugin = exports.esqlLanguagePlugin = void 0;
var _css = require("@emotion/css");
var _react = _interopRequireDefault(require("react"));
var _tool_result = require("@kbn/onechat-common/tools/tool_result");
var _classnames = _interopRequireDefault(require("classnames"));
var _eui = require("@elastic/eui");
var _visualize_esql = require("../../../tools/esql/visualize_esql");
var _visualize_lens = require("../../../tools/esql/visualize_lens");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_response/markdown_plugins.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const visualizationTagParser = () => {
  const extractAttribute = (value, attr) => {
    var _value$match;
    const regex = new RegExp(`${attr}="([^"]*)"`, 'i');
    return (_value$match = value.match(regex)) === null || _value$match === void 0 ? void 0 : _value$match[1];
  };
  const getVisualizationAttributes = value => ({
    toolResultId: extractAttribute(value, _tool_result.visualizationElement.attributes.toolResultId),
    chartType: extractAttribute(value, _tool_result.visualizationElement.attributes.chartType)
  });
  const assignVisualizationAttributes = (node, attributes) => {
    node.type = _tool_result.visualizationElement.tagName;
    node.toolResultId = attributes.toolResultId;
    node.chartType = attributes.chartType;
    delete node.value;
  };
  const visualizationTagRegex = new RegExp(`<${_tool_result.visualizationElement.tagName}\\b[^>]*\\/?>`, 'gi');
  const createVisualizationNode = (attributes, position) => ({
    type: _tool_result.visualizationElement.tagName,
    toolResultId: attributes.toolResultId,
    chartType: attributes.chartType,
    position
  });
  const visitParent = parent => {
    for (let index = 0; index < parent.children.length; index++) {
      const child = parent.children[index];
      if ('children' in child) {
        visitParent(child);
      }
      if (child.type !== 'html') {
        continue; // terminate iteration if not html node
      }
      const rawValue = child.value;
      if (!rawValue) {
        continue; // terminate iteration if no value attribute
      }
      const trimmedValue = rawValue.trim();
      if (!trimmedValue.toLowerCase().startsWith(`<${_tool_result.visualizationElement.tagName}`)) {
        continue; // terminate iteration if not starting with visualization tag
      }
      const matches = Array.from(trimmedValue.matchAll(visualizationTagRegex));
      if (matches.length === 0) {
        continue; // terminate iteration if no matches found
      }
      const visualizationAttributes = matches.map(match => getVisualizationAttributes(match[0]));
      const leftoverContent = trimmedValue.replace(visualizationTagRegex, '').trim();
      assignVisualizationAttributes(child, visualizationAttributes[0]);
      if (visualizationAttributes.length === 1 || leftoverContent.length > 0) {
        continue;
      }
      const additionalNodes = visualizationAttributes.slice(1).map(attributes => createVisualizationNode(attributes, child.position));
      const siblings = parent.children;
      siblings.splice(index + 1, 0, ...additionalNodes);
      index += additionalNodes.length;
      continue;
    }
  };
  return tree => {
    if ('children' in tree) {
      visitParent(tree);
    }
  };
};
exports.visualizationTagParser = visualizationTagParser;
function createVisualizationRenderer({
  startDependencies,
  stepsFromCurrentRound,
  stepsFromPrevRounds
}) {
  return props => {
    const {
      toolResultId,
      chartType
    } = props;
    if (!toolResultId) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 133,
          columnNumber: 9
        }
      }, "Visualization missing ", _tool_result.visualizationElement.attributes.toolResultId, ".");
    }
    const steps = [...stepsFromPrevRounds, ...stepsFromCurrentRound];
    const ToolResultAttribute = /*#__PURE__*/_react.default.createElement(_eui.EuiCode, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 140,
        columnNumber: 7
      }
    }, _tool_result.visualizationElement.attributes.toolResultId, "=", toolResultId);

    // First, look for tabular data results (from execute_esql)
    let toolResult = steps.filter(s => s.type === 'tool_call').flatMap(s => s.type === 'tool_call' && s.results || []).find(r => r.type === _tool_result.ToolResultType.tabularData && r.tool_result_id === toolResultId);

    // If not found, look for visualization results (from create_visualization)
    if (!toolResult) {
      toolResult = steps.filter(s => s.type === 'tool_call').flatMap(s => s.type === 'tool_call' && s.results || []).find(r => r.type === _tool_result.ToolResultType.visualization && r.tool_result_id === toolResultId);
    }
    if (!toolResult) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 164,
          columnNumber: 14
        }
      }, "Unable to find visualization for ", ToolResultAttribute, ".");
    }

    // Handle visualization result (pre-built Lens config)
    if (toolResult.type === 'visualization') {
      const {
        visualization
      } = toolResult.data;
      return /*#__PURE__*/_react.default.createElement(_visualize_lens.VisualizeLens, {
        lensConfig: visualization,
        dataViews: startDependencies.dataViews,
        lens: startDependencies.lens,
        uiActions: startDependencies.uiActions,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 171,
          columnNumber: 9
        }
      });
    }
    const {
      columns,
      query
    } = toolResult.data;
    if (!query) {
      return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 183,
          columnNumber: 14
        }
      }, "Unable to find esql query for ", ToolResultAttribute, ".");
    }
    return /*#__PURE__*/_react.default.createElement(_visualize_esql.VisualizeESQL, {
      lens: startDependencies.lens,
      dataViews: startDependencies.dataViews,
      uiActions: startDependencies.uiActions,
      esqlQuery: query,
      esqlColumns: columns,
      preferredChartType: chartType,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 187,
        columnNumber: 7
      }
    });
  };
}
const CURSOR = ` ᠎  `;
const loadingCursorPlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type !== 'text' && node.type !== 'inlineCode' && node.type !== 'code') {
      return;
    }
    const textNode = node;
    const indexOfCursor = textNode.value.indexOf(CURSOR);
    if (indexOfCursor === -1) {
      return;
    }
    textNode.value = textNode.value.replace(CURSOR, '');
    const indexOfNode = parent.children.indexOf(textNode);
    parent.children.splice(indexOfNode + 1, 0, {
      type: 'cursor',
      value: CURSOR
    });
  };
  return tree => {
    visitor(tree);
  };
};
exports.loadingCursorPlugin = loadingCursorPlugin;
const Cursor = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const cursorCss = (0, _css.css)`
    @keyframes blink {
      0% {
        opacity: 0;
      }
      50% {
        opacity: 1;
      }
      100% {
        opacity: 0;
      }
    }

    animation: blink 1s infinite;
    width: 10px;
    height: 16px;
    display: inline-block;
    vertical-align: middle;
    background: ${euiTheme.colors.backgroundLightText};
  `;
  return /*#__PURE__*/_react.default.createElement("span", {
    key: "cursor",
    className: (0, _classnames.default)(cursorCss, 'cursor'),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 259,
      columnNumber: 10
    }
  });
};
exports.Cursor = Cursor;
const esqlLanguagePlugin = () => {
  const visitor = (node, parent) => {
    if ('children' in node) {
      const nodeAsParent = node;
      nodeAsParent.children.forEach(child => {
        visitor(child, nodeAsParent);
      });
    }
    if (node.type === 'code' && node.lang === 'esql') {
      node.type = 'esql';
    } else if (node.type === 'code') {
      // switch to type that allows us to control rendering
      node.type = 'codeBlock';
    }
  };
  return tree => {
    visitor(tree);
  };
};
exports.esqlLanguagePlugin = esqlLanguagePlugin;