"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundInput = void 0;
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _react2 = _interopRequireDefault(require("react"));
var _conversation = require("../conversation.styles");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_rounds/round_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const labels = {
  userMessage: _i18n.i18n.translate('xpack.onechat.round.userInput', {
    defaultMessage: 'User input'
  })
};
const RoundInput = ({
  input
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const backgroundColorStyle = {
    background: `linear-gradient(
          90deg,
          ${euiTheme.colors.backgroundBasePrimary} 0%,
          ${euiTheme.colors.backgroundBasePrimary} 70%,
          ${euiTheme.colors.backgroundBaseSubdued} 100%
        )`
  };
  const inputContainerStyles = (0, _react.css)`
    align-self: end;
    max-inline-size: 90%;
    background: ${backgroundColorStyle.background};
    ${(0, _eui.euiTextBreakWord)()}
    border-radius: ${`${_conversation.ROUNDED_BORDER_RADIUS_LARGE} ${_conversation.ROUNDED_BORDER_RADIUS_LARGE} 0 ${_conversation.ROUNDED_BORDER_RADIUS_LARGE}`};
  `;
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    css: inputContainerStyles,
    paddingSize: "m",
    hasShadow: false,
    hasBorder: false,
    "aria-label": labels.userMessage,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 52,
      columnNumber: 7
    }
  }, input));
};
exports.RoundInput = RoundInput;