"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useMessageEditor = void 0;
var _react = require("react");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * Creates an imperative handle for controlling MessageEditor
 *
 * @example
 * const editor = useMessageEditor();
 * editor.focus();
 * const content = editor.getContent();
 * if (editor.isEmpty) {
 *   // Submit button disabled
 * }
 *
 * <MessageEditor messageEditor={editor} />
 */
const useMessageEditor = () => {
  const ref = (0, _react.useRef)(null);
  const [isEmpty, setIsEmpty] = (0, _react.useState)(true);
  const syncIsEmpty = (0, _react.useCallback)(() => {
    var _ref$current$textCont, _ref$current, _ref$current$textCont2;
    const content = (_ref$current$textCont = (_ref$current = ref.current) === null || _ref$current === void 0 ? void 0 : (_ref$current$textCont2 = _ref$current.textContent) === null || _ref$current$textCont2 === void 0 ? void 0 : _ref$current$textCont2.trim()) !== null && _ref$current$textCont !== void 0 ? _ref$current$textCont : '';
    setIsEmpty(content === '');
  }, []);
  const instance = (0, _react.useMemo)(() => ({
    _internal: {
      ref,
      onChange: () => {
        // If current text content is empty clear innerHTML
        // This is required so the :empty pseudo-class gets reset and the placeholder is shown
        if (ref.current && ref.current.textContent === '') {
          ref.current.innerHTML = '';
        }
        syncIsEmpty();
      }
    },
    focus: () => {
      var _ref$current2;
      (_ref$current2 = ref.current) === null || _ref$current2 === void 0 ? void 0 : _ref$current2.focus();
    },
    getContent: () => {
      var _ref$current$textCont3, _ref$current3;
      return (_ref$current$textCont3 = (_ref$current3 = ref.current) === null || _ref$current3 === void 0 ? void 0 : _ref$current3.textContent) !== null && _ref$current$textCont3 !== void 0 ? _ref$current$textCont3 : '';
    },
    setContent: text => {
      if (ref.current) {
        ref.current.textContent = text;
        syncIsEmpty();
      }
    },
    clear: () => {
      if (ref.current) {
        ref.current.textContent = '';
        setIsEmpty(true);
      }
    },
    isEmpty
  }), [isEmpty, syncIsEmpty]);
  return instance;
};
exports.useMessageEditor = useMessageEditor;