"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RenameConversationInput = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _react2 = require("@emotion/react");
var _onechatBrowser = require("@kbn/onechat-browser");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _use_conversation_id = require("../../../context/conversation/use_conversation_id");
var _use_conversation = require("../../../hooks/use_conversation");
var _use_toasts = require("../../../hooks/use_toasts");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/rename_conversation_input.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const labels = {
  inputPlaceholder: _i18n.i18n.translate('xpack.onechat.renameConversationInput.inputPlaceholder', {
    defaultMessage: 'Enter conversation name'
  }),
  confirmButton: _i18n.i18n.translate('xpack.onechat.renameConversationInput.confirmButton', {
    defaultMessage: 'Confirm rename'
  }),
  cancelButton: _i18n.i18n.translate('xpack.onechat.renameConversationInput.cancelButton', {
    defaultMessage: 'Cancel rename'
  }),
  renameErrorToast: _i18n.i18n.translate('xpack.onechat.renameConversationInput.renameErrorToast', {
    defaultMessage: 'Failed to rename conversation'
  })
};
const INPUT_WIDTH = '240px';
const inputWidthStyles = (0, _react2.css)`
  width: ${INPUT_WIDTH};
`;
const RenameConversationInput = ({
  onCancel
}) => {
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const {
    title
  } = (0, _use_conversation.useConversationTitle)();
  const {
    conversationActions
  } = (0, _conversation_context.useConversationContext)();
  const {
    addErrorToast
  } = (0, _use_toasts.useToasts)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const [newTitle, setNewTitle] = (0, _react.useState)(title || '');
  const hasFocusedRef = (0, _react.useRef)(false);

  // Callback ref that focuses only on first mount
  const inputRefCallback = (0, _react.useCallback)(el => {
    if (el && !hasFocusedRef.current) {
      hasFocusedRef.current = true;
      // Use requestAnimationFrame to ensure the element is fully mounted
      requestAnimationFrame(() => {
        el.focus();
        el.select();
      });
    }
  }, []);
  const isFormDirty = newTitle.trim() !== (title || '').trim();
  const handleRename = (0, _react.useCallback)(async () => {
    if (!conversationId || !newTitle.trim() || !isFormDirty) {
      return;
    }
    setIsLoading(true);
    try {
      await conversationActions.renameConversation(conversationId, newTitle.trim());
      onCancel();
    } catch (error) {
      addErrorToast({
        title: labels.renameErrorToast,
        text: (0, _onechatBrowser.formatOnechatErrorMessage)(error)
      });
    } finally {
      setIsLoading(false);
    }
  }, [conversationId, newTitle, conversationActions, onCancel, isFormDirty, addErrorToast]);
  const handleKeyDown = (0, _react.useCallback)(e => {
    if (e.key === 'Enter') {
      e.preventDefault();
      if (isFormDirty && newTitle.trim()) {
        handleRename();
      }
    } else if (e.key === 'Escape') {
      e.preventDefault();
      onCancel();
    }
  }, [handleRename, onCancel, isFormDirty, newTitle]);
  if (!conversationId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    alignItems: "center",
    gutterSize: "s",
    responsive: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    css: inputWidthStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    inputRef: inputRefCallback,
    value: newTitle,
    onChange: e => setNewTitle(e.target.value),
    onKeyDown: handleKeyDown,
    placeholder: labels.inputPlaceholder,
    isInvalid: !newTitle.trim(),
    isLoading: isLoading,
    disabled: isLoading,
    "data-test-subj": "renameConversationInput",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "check",
    "aria-label": labels.confirmButton,
    onClick: handleRename,
    color: "success",
    isDisabled: !newTitle.trim() || isLoading || !isFormDirty,
    "data-test-subj": "renameConversationConfirmButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 128,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    iconType: "cross",
    "aria-label": labels.cancelButton,
    onClick: onCancel,
    color: "danger",
    isDisabled: isLoading,
    "data-test-subj": "renameConversationCancelButton",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 129,
      columnNumber: 9
    }
  })));
};
exports.RenameConversationInput = RenameConversationInput;