"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.DeleteConversationModal = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _conversation_context = require("../../../context/conversation/conversation_context");
var _use_conversation_id = require("../../../context/conversation/use_conversation_id");
var _use_conversation = require("../../../hooks/use_conversation");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/conversations/conversation_header/delete_conversation_modal.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const DeleteConversationModal = ({
  isOpen,
  onClose
}) => {
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const conversationId = (0, _use_conversation_id.useConversationId)();
  const {
    title
  } = (0, _use_conversation.useConversationTitle)();
  const {
    conversationActions
  } = (0, _conversation_context.useConversationContext)();
  const confirmModalTitleId = (0, _eui.useGeneratedHtmlId)({
    prefix: 'deleteConversationModal'
  });
  const handleDelete = (0, _react.useCallback)(async () => {
    if (!conversationId) {
      return;
    }
    setIsLoading(true);
    await conversationActions.deleteConversation(conversationId);
    setIsLoading(false);
    onClose();
  }, [conversationId, conversationActions, onClose]);
  if (!isOpen || !conversationId) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiConfirmModal, {
    "aria-labelledby": confirmModalTitleId,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.deleteConversationModal.title",
      defaultMessage: "Delete conversation",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 48,
        columnNumber: 9
      }
    }),
    titleProps: {
      id: confirmModalTitleId
    },
    onCancel: onClose,
    onConfirm: handleDelete,
    cancelButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.deleteConversationModal.cancelButton",
      defaultMessage: "Cancel",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 57,
        columnNumber: 9
      }
    }),
    confirmButtonText: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.conversationTitle.deleteConversationModal.confirmButton",
      defaultMessage: "Delete",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 63,
        columnNumber: 9
      }
    }),
    buttonColor: "danger",
    defaultFocusedButton: "confirm",
    isLoading: isLoading,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 45,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement("p", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 72,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.conversationTitle.deleteConversationModal.description",
    defaultMessage: "Are you sure you want to delete the conversation {title}? This action cannot be undone.",
    values: {
      title: /*#__PURE__*/_react.default.createElement("strong", {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 77,
          columnNumber: 20
        }
      }, title || '')
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 9
    }
  })));
};
exports.DeleteConversationModal = DeleteConversationModal;