"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ConnectorSelector = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _i18n = require("@kbn/i18n");
var _aiAssistantConnectorSelectorAction = require("@kbn/ai-assistant-connector-selector-action");
var _elasticAssistant = require("@kbn/elastic-assistant");
var _use_navigation = require("../../hooks/use_navigation");
var _use_kibana = require("../../hooks/use_kibana");
var _use_default_connector = require("../../hooks/chat/use_default_connector");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/connector_selector/connector_selector.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const connectorSelectorButtonAriaLabel = _i18n.i18n.translate('xpack.onechat.connectorSelector.selectConnector', {
  defaultMessage: 'Select connector'
});
const noConnectorLabel = _i18n.i18n.translate('xpack.onechat.connectorSelector.noConnector', {
  defaultMessage: 'No connector'
});
const ConnectorSelector = ({
  selectedConnectorId,
  onSelectConnector,
  defaultConnectorId
}) => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const {
    navigateToManageConnectors
  } = (0, _use_navigation.useNavigation)();
  const {
    services: {
      http,
      settings
    }
  } = (0, _use_kibana.useKibana)();
  const [isPopoverOpen, setIsPopoverOpen] = _react.default.useState(false);
  const {
    data: aiConnectors,
    isLoading
  } = (0, _elasticAssistant.useLoadConnectors)({
    http,
    settings,
    inferenceEnabled: true
  });
  const connectors = (0, _react.useMemo)(() => aiConnectors !== null && aiConnectors !== void 0 ? aiConnectors : [], [aiConnectors]);
  const togglePopover = () => setIsPopoverOpen(!isPopoverOpen);
  const closePopover = () => setIsPopoverOpen(false);
  const panelStyles = (0, _react2.css)`
    inline-size: calc(${euiTheme.size.xxl} * 8);
  `;
  const {
    preConfiguredConnectors,
    customConnectors
  } = (0, _react.useMemo)(() => {
    const preConfigured = [];
    const custom = [];
    connectors.forEach(connector => {
      const option = {
        value: connector.id,
        label: connector.name
      };
      if (connector.isPreconfigured) {
        preConfigured.push(option);
      } else {
        custom.push(option);
      }
    });
    return {
      preConfiguredConnectors: preConfigured,
      customConnectors: custom
    };
  }, [connectors]);
  const initialConnectorId = (0, _use_default_connector.useDefaultConnector)({
    connectors,
    defaultConnectorId
  });
  const selectedConnector = connectors.find(c => c.id === selectedConnectorId);
  (0, _react.useEffect)(() => {
    if (!isLoading && initialConnectorId) {
      // No user preference set
      if (!selectedConnectorId) {
        onSelectConnector(initialConnectorId);
      }
      // User preference is set but connector is not available in the list.
      // Scenario: the connector was deleted or admin changed GenAI settings
      else if (selectedConnectorId && !selectedConnector) {
        onSelectConnector(initialConnectorId);
      }
    }
  }, [selectedConnectorId, selectedConnector, isLoading, initialConnectorId, onSelectConnector]);
  const selectedConnectorName = (selectedConnector === null || selectedConnector === void 0 ? void 0 : selectedConnector.name) || selectedConnectorId;
  const buttonLabel = selectedConnectorName || noConnectorLabel;
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    iconType: isLoading ? undefined : 'arrowDown',
    iconSide: "right",
    flush: "both",
    onClick: togglePopover,
    disabled: isLoading || connectors.length === 0,
    "data-test-subj": "onechatConnectorSelectorButton",
    "aria-haspopup": "menu",
    "aria-label": connectorSelectorButtonAriaLabel,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 110,
      columnNumber: 5
    }
  }, isLoading ? /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 120,
      columnNumber: 20
    }
  }) : buttonLabel);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    panelProps: {
      css: panelStyles
    },
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "upLeft",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_aiAssistantConnectorSelectorAction.ConnectorSelectable, {
    value: selectedConnectorId,
    onValueChange: connectorId => {
      onSelectConnector(connectorId);
      closePopover();
    },
    customConnectors: customConnectors,
    preConfiguredConnectors: preConfiguredConnectors,
    defaultConnectorId: defaultConnectorId,
    "data-test-subj": "onechatConnectorSelector",
    onAddConnectorClick: () => navigateToManageConnectors(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }));
};
exports.ConnectorSelector = ConnectorSelector;