"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AddLlmConnectionPrompt = void 0;
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _doc_links = require("../../../../../common/doc_links");
var _prompt_layout = require("./prompt_layout");
var _use_onechat_service = require("../../../hooks/use_onechat_service");
var _use_asset_base_path = require("../../../hooks/use_asset_base_path");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1764677330336017345/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/onechat/public/application/components/access/prompts/add_llm_connection_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const AddLlmConnectionPrompt = () => {
  const {
    navigationService
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    colorMode
  } = (0, _eui.useEuiTheme)();
  const assetBasePath = (0, _use_asset_base_path.useAssetBasePath)();
  const llmDocsHref = _doc_links.docLinks.models;
  const primaryButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    fill: true,
    onClick: () => {
      navigationService.navigateToLlmConnectorsManagement();
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 23,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.access.prompt.addLlm.actions.connectButton",
    defaultMessage: "Connect LLM",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 29,
      columnNumber: 7
    }
  }));
  const secondaryButton = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
    href: llmDocsHref,
    target: "_blank",
    iconType: "popout",
    iconSide: "right",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 37,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.onechat.access.prompt.addLlm.actions.docsLink",
    defaultMessage: "Read the docs",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 38,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react.default.createElement(_prompt_layout.PromptLayout, {
    imageSrc: colorMode === 'LIGHT' ? `${assetBasePath}/brain_light.svg` : `${assetBasePath}/brain_dark.svg`,
    title: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.access.prompt.addLlm.title",
      defaultMessage: "No Large Language Model detected",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 53,
        columnNumber: 9
      }
    }),
    subtitle: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.onechat.access.prompt.addLlm.description",
      defaultMessage: "Select a model to integrate with your chat experience. You can also set up your connection.",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 59,
        columnNumber: 9
      }
    }),
    primaryButton: primaryButton,
    secondaryButton: secondaryButton,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 46,
      columnNumber: 5
    }
  });
};
exports.AddLlmConnectionPrompt = AddLlmConnectionPrompt;