"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDocumentById = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getDocumentById = async ({
  id,
  index,
  esClient
}) => {
  var _response$_source;
  const {
    body: response,
    statusCode
  } = await esClient.get({
    id,
    index
  }, {
    ignore: [404],
    meta: true
  });
  if (statusCode === 404) {
    return {
      id,
      index,
      found: false
    };
  }
  return {
    id,
    index,
    found: true,
    _source: (_response$_source = response._source) !== null && _response$_source !== void 0 ? _response$_source : {}
  };
};
exports.getDocumentById = getDocumentById;